;;; -*- Package: (TRANSLISP); Mode: LISP; Syntax: Common-lisp; Base: 10 -*-
;;;_________________________________________________________________________________
;;;
;;; File:		       read-macros.lsp
;;; File Creation Date:        Mon Jan 25 19:15:51 1988
;;;
;;; Copyright (c): Forschungsgruppe INFORM, Matthias Ressel
;;;                Universitaet Stuttgart
;;;
;;; Last Modification Time:    Mon Jan 25 22:38:15 1988
;;; Last Modification By:      Matthias Ressel
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;_________________________________________________________________________________

(in-package 'translisp)

(export '(set-?-syntax reset-syntax))

#-system-translisp
(eval-when (compile eval)
  (load "pattern-macros")
  (load "franz-syntax"))

(import '(flr:backquote-reader flr:comma-reader))


(setq *pattern-read-area*
      (make-array 100
		  :element-type 'string-char
		  :fill-pointer 0))

(defun read-pattern-name (instream)
  (declare (special *pattern-read-area*))
  (setf (fill-pointer *pattern-read-area*) 0)
  (with-output-to-string (outstream *pattern-read-area*)
      (do ((ch (peek-char nil instream nil nil)
	       (peek-char nil instream nil nil)))
	  ((or (null ch)
	       (not (or (alphanumericp ch)
			(member ch 
			    '(#\! #\# #\$ #\% #\@ #\* #\+ #\- #\/ 
			      #\. #\< #\> #\= #\& #\^ #\_ #\~))))))
	  (write-char (char-upcase (read-char instream)) outstream)))
  *pattern-read-area*)

(defun ReadMacroFunction (stream char)
  (declare (ignore char)
	   (special *variable-readtable* *pattern-readtable*))
  (let ((VariableName))
    (cond ((CheckIf stream #\?)
           (cond ((CheckIf stream #\:)
                  (CreateRestrictUnnamElem (ReadRestriction stream)))
                 (t (CreateUnnamElem))))
          ((CheckIf stream #\*)
           (cond ((CheckIf stream #\:)
                  (cond ((CheckIf stream #\:)
                         (CreateRestrictUnnamSegm (ReadRestriction stream)))
                        (t (let ((ElemRestriction (ReadRestriction stream)))
                             (cond ((CheckIf stream #\:)
                                    (CreateRestrictUnnamSegmWithRestrictElems
                                      ElemRestriction
                                      (ReadRestriction stream)))
                                   (t (CreateUnnamSegmWithRestrictElems
                                        ElemRestriction)))))))
                 ((CheckIf stream #\,)
                  (CreateToBeEvaluatedAndThenSplicedExpression
                    (ReadEval stream)))
                 ((member (peek-char nil stream nil nil)
                          '(nil ; ~ #\EOF
			     #\( #\) #\[ #\]))
                  (CreateUnnamSegm))
                 ((member (peek-char nil stream nil nil)
                          '(#\space #\linefeed #\tab #\return))
                  (read-char stream nil nil)
                  (CreateUnnamSegm))
                 (t (setq VariableName (intern
                                         (concatenate
                                           'string
                                           "*"
                                           (read-pattern-name stream))))
                    (cond ((CheckIf stream #\:)
                           (cond ((CheckIf stream #\:)
                                  (CreateRestrictNamSegm
                                    VariableName
                                    (ReadRestriction stream)))
                                 (t (let ((ElemRestriction (ReadRestriction stream)))
                                      (cond ((CheckIf stream #\:)
                                             (CreateRestrictNamSegmWithRestrictElems
                                               VariableName
                                               ElemRestriction
                                               (ReadRestriction stream)))
                                            (t (CreateNamSegmWithRestrictElems
                                                 VariableName
                                                 ElemRestriction)))))))
                          (t (CreateNamSegm VariableName))))))
          ((CheckIf stream #\,)
           (CreateToBeEvaluatedAndThenInsertedExpression (ReadEval stream)))
          ((CheckIf stream #\`)
           (CreateQuoteFormInEval
             (read-with-readtable stream *pattern-readtable*)))
          ((member (peek-char nil stream nil nil)
                   '(#\space #\linefeed #\tab #\return))
           '?)
          (t (setq VariableName (intern (read-pattern-name stream)))
             (cond ((CheckIf stream #\:)
                    (CreateRestrictNamElem VariableName
                                           (ReadRestriction stream)))
                   (t (CreateNamElem VariableName)))))))

; Readtable and Syntax Stuff
; ==========================

(defparameter *old-readtable* (copy-readtable *readtable*)
  "Is set to value of *readtable* before invocation of ?-syntax")

(defparameter *pattern-readtable* 
	      (let ((readtable (copy-readtable *readtable*)))
		(set-macro-character #\` 'backquote-reader nil readtable)
		(set-macro-character #\, 'comma-reader nil readtable)
		(set-macro-character #\? 'ReadMacroFunction t  readtable)
		readtable)
  "*readtable* + ?-syntax")
  
(defparameter *memq-restriction-readtable*
	      (let ((readtable (copy-readtable *readtable*)))
		(set-macro-character #\` 'backquote-reader nil readtable)
		(set-macro-character #\, 'comma-reader nil readtable)
		(set-syntax-from-char #\} #\) readtable)
	        (set-syntax-from-char #\? #\? readtable *old-readtable*)
		readtable))

(defparameter *evalform-readtable*
	*pattern-readtable*)

(defvar *old-readtable-already-set* nil
  "soll verhindern, dass *old-readtable* inkonsistenten Wert erhaelt")

#+kcl 
(defun kcl-copy-readtable (from-readtable to-readtable)
  (dotimes (i 128)
     (let ((ch (int-char i)))
       (set-syntax-from-char ch ch to-readtable from-readtable))))

(defun set-?-syntax ()
  (unless *old-readtable-already-set*
    (setq *old-readtable-already-set* t)
    #-kcl (copy-readtable *readtable* *old-readtable*)
    #+kcl (kcl-copy-readtable *readtable* *old-readtable*))	; Bug in KCL
  (set-macro-character #\` 'backquote-reader)
  (set-macro-character #\, 'comma-reader)
  (set-macro-character #\? 'ReadMacroFunction t *readtable*))

(defun reset-syntax ()
  #-kcl (copy-readtable *old-readtable* *readtable*)
  #+kcl (kcl-copy-readtable *old-readtable* *readtable*) 
  (setq *old-readtable-already-set* nil))

;; Pattern and Restriction Read Functions

(defun read-with-readtable (stream table)
  (let ((*readtable* table))
    (read-preserving-whitespace stream nil nil)))

(defun ReadRestriction (stream)
  (case (peek-char nil stream nil nil)
	(#\{
	 (let ((pred
		 (let ((*readtable* *memq-restriction-readtable*))
		   (read-char stream)
		   (read-delimited-list #\} stream t))))
	   (if (all-symbols pred)
	       (let ((pred (CreateMemqExpression pred)))
		 (list `(lambda (IT)
			  (member IT ',(MemElements pred) :test #'eq))
		       pred))
	       (let ((pred (CreateMemberExpression pred)))
		 (list `(lambda (IT)
			  (member IT ',(MemElements pred) :test #'equal))
		       pred)))))
	(#\(
	 (let ((pred
		 (read-with-readtable stream *pattern-readtable*)))
	   (list `(lambda (IT)
		    ,pred) pred)))
	(otherwise
	  (let ((pred
		  (intern (read-pattern-name stream))))
	    (list pred pred)))))

;;; Die folgende Funktion wird noch von deftrigger benoetigt

(defun CreateRestriction (pred)
  (if (atom pred)
      (list pred pred)
      (cond ((MemqExpression? pred)
             (list `(lambda (IT)
                      (member IT ',(MemElements pred) :test #'eq))
                   pred))
            ((MemberExpression? pred)
             (list `(lambda (IT)
                      (member IT ',(MemElements pred) :test #'equal))
                   pred))
            (t (list `(lambda (IT)
                        ,pred) pred)))))

(defun all-symbols (itemlist)
  (or (null itemlist)
      (and (symbolp (car itemlist))
           (all-symbols (cdr itemlist)))))

(defun ReadEval (stream)
  (let ((evalform (read-with-readtable stream *evalform-readtable*)))
    (CreateEvalForm evalform)))

(defun CheckIf (stream character)
  (and (eql (peek-char nil stream nil nil) character)
       (read-char stream nil nil)))

;;;----------------------------------------------------------------------
;;; For Testing
;;;----------------------------------------------------------------------

#||
(defun pattern-test ()
  (dolist (pattern '("??"
		     "??:testp"
		     "??:{elem1 elem2}"
		     "??:{(list1) elem2}"
		     "??:(testp IT)"
		     "?*"
		     "?*::segm-testp"
		     "?*:elem-testp:segm-testp"
		     "?*:elem-testp"
		     "?,var"
		     "?,(foo ?x)"
		     "?,(foo ?`(?car ?cdr))"
		     "?*,(foo ?x)"
		     "?*,(foo)"
		     "?*var"
		     "?*var::testp"
		     "?var"
		     "?var:testp"
		     "?`(?car ?cadr)"))
	  (with-input-from-string (str pattern)
	     (format t "~&~20a =is-read-as=> ~s" 
		     pattern 
		     (read-preserving-whitespace str)))))
||#


(setf (get 'read-macros 'version) '2.4)
