;;; -*- Package: TRANSLISP; Mode: LISP; Syntax: Common-lisp; Base: 10 -*-

(in-package 'translisp)

(export '(init-rule-file clean-rule-file include-file-rules
	  TransformStandard FileRules NeverProtocol created author))

#-system-translisp
(eval-when (compile eval)
  (load "read-macros"))

(defmacro init-rule-file ()
  '(progn
     (eval-when (compile eval)
       (unless (get 'rule-macros-compile 'version)
	 (load "rule-macros-compile")))
     ;; auch bei der Verwendung uncompilierter Regelfiles
     ;; werden alle Evalformen zu extra Funktionen gemacht.
     ;; Grund: Es gibt Probleme mit dem Umdefinieren der
     ;; defrule Funktion
;     (eval-when (eval)                   
;       (load "rule-macros-eval"))
     (eval-when (compile load eval)
       (unless (boundp '*rulesets-defined*)
	 (setq *rulesets-defined* nil)))
     (eval-when (compile eval)
       (set-?-syntax))))

(defmacro clean-rule-file ()
  `(eval-when (compile)
     (reset-syntax)))

(eval-when (compile eval)
  (set-?-syntax))

(defmacro include-file-rules ()
  (copy-tree
    '(progn
       (Defruleset TransformFileForm (form))
       
       (Defruleset TransformFile (file))

       (Defrule  transform-file-default TransformFile -100
		 (?*expr)
		 ==>
		 (?*,(mapcar 'TransformFileForm ?*expr))
		 (FileRules)
		 (NeverProtocol)
		 ((author "Matthias Ressel") (created "Fri Feb 20 18:31:00 1987")))
       
       (Defrule  preserve-separators-default TransformFileForm -100
		 ($separator$ ?args)
		 ==>
		 ?$left$
		 (FileRules)
		 (NeverProtocol)
		 ((author "Matthias Ressel") (created "Fri Feb 20 18:32:02 1987")))
       
       (Defrule  transform-else-default TransformFileForm -100
		 ?x
		 ==>
		 ?,(let ((*print-header* ?x))
		     (declare (special *print-header*))
		     (TransformStandard ?x))
		 (FileRules)
		 (NeverProtocol)
		 ((author "Matthias Ressel") (created "Fri Feb 20 18:33:20 1987")))
       
       (Defrule  splice-commented-form-default TransformFileForm -100
		 ($commented-form$ ?form ?*comments)
		 ==>
		 ?*,?`(?*comments ?,(TransformStandard ?form))
		 (FileRules)
		 (NeverProtocol)
		 ((author "Matthias Ressel") (created "Wed Apr 22 21:17:23 1987")))
       )))

(eval-when (compile eval)
  (reset-syntax))


(setf (get 'init-rule-handling 'version) '1.2)