;;;_________________________________________________________________________________
;;;
;;;                       System: defsys
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe INFORM, Andreas Girgensohn
;;;                Universitaet Stuttgart
;;;
;;; File:		       defsys.lsp
;;; File Creation Date:        Thu Sep  3 09:29:35 1987
;;; Last Modification Time:    Mon Dec 14 14:20:08 1987
;;; Last Modification By:      Andreas Girgensohn
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;; 17.1.88, Matthias: changed *pathname-extensions*, make-source-pathname
;;;                    make-binary-pathname
;;;                    added default-pathname
;;;_________________________________________________________________________________
  ;;   
;;;;;; load-system
  ;;
;;; Yet Another Sort Of General System Facility and friends.
;;; 

(export '(defsys make-sys load-system))

(defvar *pathname-extensions* '(".lsp"   . ".o"))	; for kcl


(defstruct (module (:constructor make-module
				 (name load-env comp-env recomp-reasons root-p))
		   (:print-function print-module))
  name
  load-env
  comp-env
  recomp-reasons
  root-p)

(defun print-module (m s d)
  (declare (ignore d))
  (format s
	  "#<Module ~A L:~@A  C:~@A  R:~@A>"
	  (module-name m)
	  (module-load-env m)
	  (module-comp-env m)
	  (module-recomp-reasons m)))

(defstruct (defsys (:constructor make-defsys (name dependency)))
  name
  dependency)

(defmacro defsys (name &body description)
  (let ((modules))
    (setq description
	  (do ((d description (cdr d)))
	      ((not (eq (caar d) :module))
	       d)
	      (push (cdar d) modules)))
    (when modules (setq modules (nreverse modules)))
    `(locally (declare (special ,name))
	      (setq ,name (make-sys ',name
				    ',modules
				    ',(copy-list description))))))

(defun make-sys (name modules dependency &aux (files ()) module-names)
  (flet ((files-or-module (m &optional flag)
	   (cond ((and m (symbolp m))
		  (let ((entry (assoc m modules)))
		    (if entry
			(cdr entry)
			(error "Can't find module of name ~S???" m))))
		 (flag (list m))
		 (t m))))
    (dolist (d dependency)
      (dolist (module (files-or-module d t))
	(let ((names (files-or-module (car module) t))
	      (load-env (files-or-module (cadr module)))
	      (comp-env (files-or-module (caddr module)))
	      (recomp-reasons (files-or-module (cadddr module)))
	      (root-p (or (null (cddddr module)) (car (cddddr module)))))
	  (dolist (name names)
	    (push (make-module name
			       (if (eq load-env 't)
				   (reverse module-names)
				   load-env)
			       (mapcar #'(lambda (c)
					   (if (listp c)
					       c
					       (list c :binary)))
				       (if (eq comp-env 't)
					   (reverse (cons name module-names))
					   comp-env))
			       recomp-reasons
			       root-p)
		  files)
	    (push name module-names)))))
    (make-defsys name files)))

(defun load-system (system mode *default-pathname-defaults* &key simulate)
  (declare (special *default-pathname-defaults*))
  (let ((loaded ())    ;A list of the modules loaded so far.
	(compiled ())  ;A list of the modules we have compiled.
	(*modules-to-source-load* ())
	(modules (defsys-dependency system)))
    (declare (special *modules-to-source-load*))
    (labels
      ((find-module
	 (name)
	 (or (car (member name modules :key #'module-name :test #'equal))
	     (error "Can't find module of name ~S???" name)))
       (needs-compiling-p
	 (m)
	 (or (null (probe-file (make-binary-pathname (module-name m))))
	     (eq (module-recomp-reasons m) 't)
	     (dolist (r (module-recomp-reasons m))
	       (when (member (find-module r) compiled)
		 (return t)))
	     (dolist (r (module-recomp-reasons m))
	       (when (needs-compiling-p (find-module r))
		 (return t)))
	     (let ((binary-write-date
		     (file-write-date (make-binary-pathname (module-name m)))))
	       (or (dolist (r (module-recomp-reasons m))
		     (when (> (file-write-date (make-binary-pathname r))
			      binary-write-date)
		       (return t)))
		   (> (file-write-date (make-source-pathname (module-name m)))
		      binary-write-date)))))
       (compile-module
	 (m)
	 (unless (member m compiled)
	   (assure-compile-time-env m)
	   (format t "~&Compiling ~A..." (module-name m))
	   (unless simulate
	     (compile-file (make-source-pathname (module-name m))))
	   (push m compiled)))
       (load-module
	 (m &optional source-p)
	 (setq source-p (or (if (member m *modules-to-source-load*) t nil)
			    source-p
			    (eq mode :sources)))
	 (let ((already-loaded-p (dolist (l loaded)
				   (and (eq (car l) m)
					(eq (cdr l) source-p)
					(return t)))))
	   (unless already-loaded-p
	     (when (or (and (eq mode :compile)
			    (needs-compiling-p m))
		       (eq mode :force))
	       (compile-module m))
	     (unless (or source-p
			 (probe-file (make-binary-pathname (module-name m))))
	       (setq source-p t)
	       (setq already-loaded-p (dolist (l loaded)
					(and (eq (car l) m)
					     (eq (cdr l) source-p)
					     (return t))))))
	   (unless already-loaded-p
	     (assure-load-time-env m)
	     (cond (source-p
		     (format t "~&Loading source of ~A..." (module-name m))
		     (unless simulate
		       (load (make-source-pathname (module-name m)))))
		   (t (format t "~&Loading ~A..." (module-name m))
		      (unless simulate
			(load (make-binary-pathname (module-name m))))))
	     (push (cons m source-p) loaded))))
       (assure-compile-time-env
	 (m)
	 (let ((*modules-to-source-load* (cons m *modules-to-source-load*)))
	   (declare (special *modules-to-source-load*))	;Should not have to but...
	   (dolist (c (module-comp-env m))
	     (when (eq (cadr c) :source)
	       (push (find-module (car c)) *modules-to-source-load*)))
	   (dolist (c (module-comp-env m))
	     (load-module (find-module (car c))))))
       (assure-load-time-env
	 (m)
	 (dolist (l (module-load-env m))
	   (load-module (find-module l))))
       )
      (ecase mode
	(:compile
	  (dolist (module modules)
	    (when (needs-compiling-p module)
	      (compile-module module))))
	(:force
	  (dolist (module modules)
	    (compile-module module)))
	(:load
	  (dolist (module modules)
	    (when (module-root-p module)
	      (load-module module))))
	(:sources
	  (dolist (module modules)
	    (when (module-root-p module)
	      (load-module module t)))))
      )))

(defun default-pathname (pathname default)
  "like merge-pathnames, but merges directories if appropriate"
  ;; Bug: do not use host or device in pathname (foolish anyway)
  (cond ((eq (car (pathname-directory (user-homedir-pathname))) ; name for root
	     (car (pathname-directory pathname)))
	 ; forget about dirctories in default
	 ; so do a normal merge-pathnames
	 (merge-pathnames pathname default)
	 )
	(t
	 ; add the directory part of pathname to the directory part
	 ; of default
	 (merge-pathnames
	    (concatenate 'string
	       (directory-namestring default)
	       (directory-namestring pathname))
	    (merge-pathnames
	     (file-namestring pathname)
	     default)))))

(defun make-source-pathname (name)
  (merge-pathnames
   (car *pathname-extensions*)
   (default-pathname
    #-VMS (string-downcase (string name))
    #+VMS (string-downcase (substitute #\_ #\- (string name)))
    *default-pathname-defaults*)))

(defun make-binary-pathname (name)
  (merge-pathnames
   (cdr *pathname-extensions*)
   (default-pathname
    #-VMS (string-downcase (string name))
    #+VMS (string-downcase (substitute #\_ #\- (string name)))
    *default-pathname-defaults*)))
  
#|| old
(defun make-source-pathname (name)
  (make-pathname
    :name #-VMS (string-downcase (string name))
          #+VMS (string-downcase (substitute #\_ #\- (string name)))
    :type (car *pathname-extensions*)
    :defaults *default-pathname-defaults*))

(defun make-binary-pathname (name)
  (make-pathname
    :name #-VMS (string-downcase (string name))
          #+VMS (string-downcase (substitute #\_ #\- (string name)))
    :type (cdr *pathname-extensions*)
    :defaults *default-pathname-defaults*))
||#
