;;; -*- Package: CL-USER; Syntax: COMMON-LISP -*-

(in-package :cl-user)

#+(not (or :mcl :genera :allegro :lispworks))
(error "No system declaration for ~A" (lisp-implementation-type))


;;;; Logical Pathnames

#-:Genera
(setf (logical-pathname-translations "measures")
      `(#+:allegro ("*.*" ,*load-pathname*)
	#-:allegro ("**;*.*"           ; directory wildcards do not seem to
                                       ; work correctly in ACL
		    #+:mcl ,(full-pathname
                             (concatenate 'string
                                          (directory-namestring
                                           (truename *loading-file-source-file*))
                                          "**:*.*"))
                    #+:lispworks
                    ,(concatenate 'string
                                  (directory-namestring *load-pathname*)
                                  "**/*.*"))))


;;;; Macintosh Common Lisp 2.0p2

#+:mcl
(unless (find-package "CC")
  (error "No system construction tools available.
DEFUNIT from Guillaume Cartier expected. You can also load the system
by hand. Just load the files package and measures in this order."))

;;; Mark Kantrowitz' defsystem utility has problems with logical pathnames.

#+:mcl
(defunit "MEASURES"
  (:source-pathname "measures:")
  (:binary-pathname "measures:bin;")
  (:components "package"
               "measures"
               "reader-setup"))



;;;; Allegro Common Lisp 4.1
;;;; with patches from ftp.uu.net:/vendor/franz/...

#+:allegro
(defsystem :measures
    (:default-pathname "measures:")
  (:serial "package"
           "measures" 
           "reader-setup"))



;;;; Harlequin Lispworks 3.1

#+:LispWorks
(defsystem :measures
  (:default-pathname "MEASURES:"
   :object-pathname  "MEASURES:BIN"
   :default-type :lisp-file)
  :members
  ("package" 
   "measures"
   "reader-setup")
  :rules
  ((:in-order-to :compile :all
		 (:requires (:load :previous)))))



;;;; Symbolics Common Lisp (Genera 8.1)

#+:Genera
(scl:defsystem :measures
    (:default-pathname             "measures:source;"
     :default-destination-pathname "measures:bin;")
  (:serial
    "package"
    "measures"
    "symbolics-patch-1"
    "symbolics-patch-2"
    "reader-setup"))
