;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:USER; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "*READ-RASTER-FILE1"*
;1;; Reading and displaying Andrew Raster Format images.*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;; *28 Feb 891  Jamie Zawinski*	1 Created.*
;1;;*



(defun 4read-raster-file-1 *(stream &optional search)
  (declare (values bitmap id version options xscale yscale xoffset yoffset subwidth subheight id2 width height))
  (let (id version options xscale yscale xoffset yoffset subwidth subheight
	id2 width height)
    (labels ((ditch-white (stream)
	       (do* ((c (read-char stream) (read-char stream)))
		    ((not (member c '(#\Space #\Tab #\Newline) :test #'char=))
		     (unread-char c stream))))
	     (read-string-of-length (n stream)
	       (let* ((string (make-string n)))
		 (dotimes (i n) (setf (char string i) (read-char stream)))
		 string))
	     (looking-for (string stream)
	       (ditch-white stream)
	       (let* ((line (read-string-of-length (length string) stream)))
		 (unless (string= string line) (error "3Found ~S instead of ~S*" line string))))
	     (read-until (char stream)
	       (ditch-white stream)
	       (let* ((line (make-array 50 :element-type 'string-char :fill-pointer 0)))
		 (do ((c nil)
		      (i 0 (1+ i)))
		     ((and c (char= c char)))
		   (vector-push-extend (setq c (read-char stream)) line))
		 line))
	     )
      (cond (search
	     (loop
	       (let* ((line (read-line stream))
		      (i nil))
		 (when (and (search "3\\begindata*" line) (setq i (search "3raster*" line)))
		   (setq id (parse-integer line :junk-allowed t :start i))
		   (return)))))
	    (t
	     (looking-for "3\\begindata*" stream)
	3     *(looking-for "3{*" stream)
	      (looking-for "3raster*" stream)
	      (looking-for "3,*" stream)
	      (ditch-white stream)
	      (setq id (parse-integer (read-until #\} stream) :junk-allowed t))))
      (setq version (parse-integer (read-until #\Space stream) :junk-allowed t))
      (assert (>= version 2))
      (ditch-white stream)
      (let* ((line (read-line stream))
	     (index 0))
	(multiple-value-setq (options   index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (xscale    index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (yscale    index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (xoffset   index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (yoffset   index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (subwidth  index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (subheight index) (parse-integer line :junk-allowed t :start index)))
      (looking-for "3bits*" stream)
      (ditch-white stream)
      (let* ((line (read-line stream))
	     (index 0))
	(multiple-value-setq (id2    index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (width  index) (parse-integer line :junk-allowed t :start index))
	(multiple-value-setq (height index) (parse-integer line :junk-allowed t :start index)))
      (assert (< 0 width  1000000))
      (assert (< 0 height 1000000))
      
      (let* ((bitmap #+LISPM (make-array #+LISPM (list height (+ 32 (* 32 (floor (1- width) 32))))
					 #-LISPM (list width height)
					 :element-type 'BIT :initial-element 1)))
	
	(flet ((setmap-byte (ubyte bitmap byte-x bit-y)
	         (let* ((x (* byte-x 8)))
		   (dotimes (i 8)
		     (setf #+LISPM (aref bitmap bit-y x)
			   #-LISPM (aref bitmap x bit-y)
			   (ldb (byte 1 (- 7 i)) ubyte))
		     (incf x))))
	       (read-hex (stream)
		 (let* ((c1 (read-char stream))
			(c2 (read-char stream)))
		   (if (digit-char-p c1)
		       (setq c1 (- (char-int c1) #.(char-int #\0)))
		       (setq c1 (- (char-int (char-downcase c1)) #.(- (char-int #\a) 10))))
		   (if (digit-char-p c2)
		       (setq c2 (- (char-int c2) #.(char-int #\0)))
		       (setq c2 (- (char-int (char-downcase c2)) #.(- (char-int #\a) 10))))
		   (lognot (+ (* 16 c1) c2)))))
	  (dotimes (row height)
	    (let* ((x 0))
	      (loop
		(let* ((c (read-char stream))
		       (code (char-int c)))
		  (cond ((or (<= 0 code 32)
			     (> code 126)
			     (member c '(#\@ #\[ #\] #\^ #\_ #\` #\} #\~) :test #'char=))
			1  *;1; This is considered whitespace, and is ignored.*
			 nil)
			
			((member c '(#\{ #\\) :test #'char=)
			1  *;1; These are (illegal) end-of-line characters.*
			 (return))
			
			((char= c #\|)
			1  *;1; Legal end-of-row.*
			 (return))
			
			((<= 27 code 47)	;1 Repeat code.  Read a hex code and repeat it.*
			 (let* ((repeat-count (- code 31))
				(value (read-hex stream)))
			   (dotimes (i repeat-count)
			     (setmap-byte value bitmap x row)
			     (incf x))))

			((<= #.(char-code #\g) code #.(char-code #\z))		;1 Multiple white bytes.*
			 (let* ((repeat-count (- code #.(1- (char-code #\g)))))
			   (dotimes (i repeat-count)
			     (setmap-byte #xFF bitmap x row)
			     (incf x))))

			((<= #.(char-code #\G) code #.(char-code #\Z))		;1 Multiple black bytes.*
			 (let* ((repeat-count (- code #.(1- (char-code #\G)))))
			   (dotimes (i repeat-count)
			     (setmap-byte #x00 bitmap x row)
			     (incf x))))

			(t (unread-char c stream)
			   (setmap-byte (read-hex stream) bitmap x row)
			   (incf x))
			))))))
	(values bitmap
		id version options xscale yscale xoffset yoffset subwidth subheight
		id2 width height)))))


(defun 4read-raster-file *(pathname &optional search)
  (with-open-file (s pathname :direction :input)
    (multiple-value-bind (bitmap id version options xscale yscale xoffset yoffset subwidth subheight id2 width height)
			 (read-raster-file-1 s search)
      (declare (ignore id version options xscale yscale xoffset yoffset subwidth subheight id2))
      (values bitmap width height))))

(defun 4read-and-show-raster-file *(pathname &optional search)
  (let* ((window tv:selected-window))
    (multiple-value-bind (b w h) (read-raster-file pathname search)
      (beep)
      (process-wait "3exp*" #'(lambda (x) (eq x tv:selected-window)) window)
      (send window :clear-screen)
      (setq w (min w (tv:sheet-inside-width window)))
      (setq h (min h (tv:sheet-inside-height window)))
      (tv:prepare-sheet (window)
	(bitblt tv:alu-seta w h b 0 0 (tv:sheet-screen-array window)
				      (tv:sheet-left-margin-size window)
				      (tv:sheet-top-margin-size window)))
      (read-char))))
