;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I CPTFONT CPTFONTB HL12B CPTFONTBI) -*-

;1;; File "3POSTSCRIPT-MODE*".*
;1;; A Zmacs major-mode for editing PostScript.*
;1;; Derived from/inspired by the GNU Emacs code by Chris Maio.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   19 Apr 90*	1Jamie Zawinski*		1Created.*
;1;;   24 Apr 90*	1Mabry Tyson (WMT)  *	1Modified to run on Symbolics.  Since the ZWEI package on Symbolics*
;1;;*					1 is ZetaLisp, not Common Lisp, qualified many functions with 5LISP:*.*
;1;;*					1Removed some font-changes that symbolics couldn't deal with.*
;1;;*					1Added some conditional #+TI / #+SYMBOLICS forms.*
;1;;*   125 Apr 90*	1Jamie Zawinski *		1Improved handling of automatic re-indentation.  It was re-indenting*
;1;;*					1 far too much for my tastes...  Improved sectionizing too.*

;1;; 5PostScript Style Note:**
;1;;*
;1;; Because of some Lisp-syntax-related assumptions deep within Zmacs, if you indent *
;1;; your PostScript code like this:*		1instead of like this:*
;1;;*
;1;;*	5/myproc {*			5/myproc*
;1;;*	1  5doodle doodle dee**		5{   doodle doodle dee*
;1;;*	1  5wubba wubba wubba**		5    wubba wubba wubba*
;1;;*	5} def*				5} def*
;1;;*
;1;; then automatic paren-matching won't work.  Zmacs assumes that a "defun" begins with*
;1;; an open-paren in column zero.  As you see, the second of the above examples satisfies*
;1;; this, but the first doesn't.*
;1;;*


(defvar 4*ps-indent-level** 4 "2Indentation to be used inside of PostScript blocks or arrays.*")


;(defun 4delete-memoization *()
;  (do ((line (bp-line (interval-first-bp *interval*))
;	     (line-next line)))
;      ((null line))
;    (remf (line-contents-plist line) 'lisp-parse-line)))


(defmajor 4com-postscript-mode* postscript-mode "PostScript"
          "2Sets things up for editing PostScript code.
In this mode, Tab and Meta-Control-Q attempt to indent code
based on the position of {}, [], and begin/end pairs.  The variable
*ps-indent-level* controls the amount of indentation used inside
arrays and begin/end pairs.*" ()
  
  (setq *mode-word-syntax-table* *word-syntax-table*)
  
  (set-char-syntax list-open *mode-list-syntax-table* #\[)
  (set-char-syntax list-open *mode-list-syntax-table* #\{)
  (set-char-syntax list-open *mode-list-syntax-table* #\<)

  (set-char-syntax list-close *mode-list-syntax-table* #\])
  (set-char-syntax list-close *mode-list-syntax-table* #\})
  (set-char-syntax list-close *mode-list-syntax-table* #\>)

  (set-char-syntax list-comment *mode-list-syntax-table* #\%)

  (set-char-syntax list-alphabetic *mode-list-syntax-table* #\|)
  (set-char-syntax list-alphabetic *mode-list-syntax-table* #\;)
  (set-char-syntax list-alphabetic *mode-list-syntax-table* #\#)
  (set-char-syntax list-alphabetic *mode-list-syntax-table* #\`)
  (set-char-syntax list-alphabetic *mode-list-syntax-table* #\")
  (set-char-syntax list-alphabetic *mode-list-syntax-table* #\/)

  (set-char-syntax word-alphabetic *atom-word-syntax-table* #\|)
  (set-char-syntax word-alphabetic *atom-word-syntax-table* #\;)
  (set-char-syntax word-alphabetic *atom-word-syntax-table* #\#)
  (set-char-syntax word-alphabetic *atom-word-syntax-table* #\`)
  (set-char-syntax word-alphabetic *atom-word-syntax-table* #\")
  
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\/)
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\[)
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\{)
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\<)
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\])
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\})
  (set-char-syntax word-delimiter *atom-word-syntax-table* #\>)
  
  (setq *paragraph-delimiter-list* '(#\Newline))
  (setq *space-indent-flag* t)
  (setq *comment-start* "%")
  (setq *comment-begin* "%% ")
  (setq *comment-end* "")
  (setq *comment-column* (* 60. 6))
  (set-comtab *mode-comtab* '(#\Tab com-indent-for-PostScript
			      #\Meta-Control-Q com-postscript-indent-sexp
			      #\Rubout com-tab-hacking-rubout
			      ;1;*
			      ;1; These are the characters which 2might* cause automatic re-indentation*
			      ;1; of the current line.  The letters 5'd'* and 5'f'* are here so that the line*
			      ;1; reindents properly when the user types 5'end'* or 5'cdef'*.*
			      ;1;*
			      #\{ com-self-insert-and-indent-for-PostScript
			      #\} com-self-insert-and-indent-for-PostScript
			      #\[ com-self-insert-and-indent-for-PostScript
			      #\] com-self-insert-and-indent-for-PostScript
			      #\d com-self-insert-and-indent-for-PostScript
			      #\f com-self-insert-and-indent-for-PostScript
			      ))
  )

(defprop 4PostScript-Mode *:PostScript EDITING-TYPE)

#+EXPLORER
(compiler-let ((sys:compile-encapsulations-flag t))
  ;1; 2Force the -*- line to begin with 5"%!"* instead of 5"%%"*.**
  (sys:advise STORE-ATTRIBUTE-LIST :around 'attr-comment nil
    (let ((*comment-begin* (if (eq (get *major-mode* 'editing-type) :PostScript)
			       "3%!ps *"
			       *comment-begin*)))
      :DO-IT)))

#+SYMBOLICS
(defmethod 4(:attribute-comment-start postscript-mode*) ()
  "%!ps ")

(defcom 4com-indent-for-PostScript*
	"2Indent the current line using PostScript syntax.
 With a numeric argument, indent that many lines.*" ()
  (if *numeric-arg-p*
      (dotimes (i *numeric-arg*)
	(indent-PostScript-line (beg-line (point)))
	(when (lisp:every #'(lambda (x) (lisp:member x *blanks* :test #'char-equal)) (bp-line (point)))
	  (delete-around *blanks* (point)))
	(move-bp (point) (beg-line (point) 1 t)))
      (indent-PostScript-line (beg-line (point))))
  DIS-TEXT)


(defcom 4com-PostScript-indent-sexp*
	"2Reindent all lines of the next PostScript form.*" ()
  (with-bp (bp (point) :moves)
    (let* ((bp2 (forward-list (point) 1 t))
	   (line (bp-line bp2)))
      (do ()
	  ((eq line (bp-line (point)))
	   (move-bp (point) bp))
	(indent-PostScript-line (point))
	(when (lisp:every #'(lambda (x) (lisp:member x *blanks* :test #'char-equal)) (bp-line (point)))
	  (delete-around *blanks* (point)))
	(move-bp (point) (beg-line (point) 1 t)))))
  dis-text)


(defcom 4com-self-insert-and-indent-for-PostScript*
	"2Insert this character, and (maybe) reindent the current line for PostScript.*" ()
  (com-self-insert)
  ;1;*
  ;1; Re-indent if we have just typed 5end* or 5cdef*, or if we have just typed*
  ;1; a closing delimiter as the first non-white character on the line.*
  ;1;*
  (when (or (and (or (char-equal *last-command-char* #\])
		     (char-equal *last-command-char* #\}))
		 (let ((beg (forward-over *blanks* (beg-line (point)))))
		   (bp-= beg (forward-char (point) -1))))
	    (looking-at-backward (point) "end")
	    (looking-at-backward (point) "cdef"))
    (com-indent-for-PostScript))
  DIS-TEXT)


(defun 4indent-PostScript-line* (&optional (point (point)))
  "2Indents a line of PostScript code.*"
  (with-bp (bp (beg-line point) :moves)
    (let* ((bp2 (forward-over *blanks* bp))
	   (x (zwei:string-width (bp-line bp2) 0 (bp-index bp2))))
      (delete-around *blanks* bp)
      (unless (or (lisp:string-equal "%%" (bp-line bp) :end2 2)	;1 "%%" comments stay at left margin*
		  (and (PostScript-top-level-p)
		       (progn (indent-to bp x) t)
		       ))
	(if (and (not (bp-= point (interval-last-bp *interval*)))
		 (= list-close (list-syntax (bp-char point))))
	    ;1; indent close-delimiter*
	    (indent-PostScript-close-brace)
	    (if (or (looking-at point "classend")
		    (looking-at point "dictend")
		    (looking-at point "cdef")
		    (looking-at point "end"))
		;1; indent end token*
		(indent-PostScript-end-token)
		;1; indent line after open delimiter*
		(indent-PostScript-block-line))
	    ))))
  (when (zerop (bp-index (point)))
    (move-bp (point) (forward-over *blanks* (point)))))


(defun 4indent-PostScript-close-brace* ()
  "2Internal function to indent a line containing a an array close delimiter (\] or \}).*"
  (with-bp (bp (beg-line (point)) :moves)
    (move-bp bp (forward-sexp (forward-char bp) -1 t))
    (unless (= 1 (count-lines bp (point)))
      (move-bp bp (bp-line bp) 0)
      (move-bp bp (forward-over *blanks* bp))
      (let* ((x (zwei:string-width (bp-line bp) 0 (bp-index bp))))
	(move-bp bp (beg-line (point)))
	(delete-around *blanks* bp)
	(indent-to bp x))))
  (when (zerop (bp-index (point)))
    (move-bp (point) (forward-over *blanks* (point)))))


(defun 4indent-PostScript-end-token* ()
  "2Indent an \"end\" token or array close delimiter.*"
  (let ((goal (PostScript-block-start)))
    (if goal
	(indent-to (beg-line (point)) (with-stack-list* (*blanks* #\[ #\{ *blanks*)
					(line-indentation (bp-line goal))))
	(indent-relative (beg-line (point))))
    (when (zerop (bp-index (point)))
      (move-bp (point) (forward-over *blanks* (point))))
    ))


(defun 4indent-PostScript-block-line* ()
  "2Indent a line which does not open or close a block.*"
  (block NIL
    (with-bp (bp (or (PostScript-block-start) (return)) :moves)
      (move-bp bp (with-stack-list* (*blanks* #\[ #\{ *blanks*)
		    (forward-over *blanks* (beg-line bp))))
      (let ((hpos (if (zerop (bp-index bp))
		      (* *ps-indent-level* (tv:sheet-char-width (window-sheet *window*)))
		      (+ (* *ps-indent-level* (tv:sheet-char-width (window-sheet *window*)))
			 (line-indentation (bp-line bp))))))
	
	(cond ((eq (bp-line bp) (line-previous (bp-line (point))))
	       (indent-to (beg-line (point)) hpos))
	      (t
	       (let ((prev-line (do ((l (bp-line (point)))
				     (first (bp-line (interval-first-bp *interval*))))
				    ((eq l first) nil)
				  (setq l (line-previous l))
				  (or (zerop (lisp:length l))
				      (lisp:every #'(lambda (x) (lisp:member x *blanks* :test #'char-equal)) l)
				      (return l)))))
		 (indent-to (beg-line (point)) (line-indentation prev-line)))
	       ))
	(when (zerop (bp-index (point)))
	  (move-bp (point) (forward-over *blanks* (point))))
	))))


(defun 4PostScript-block-start* ()
  "2Returns the character position of the character following the nearest
 enclosing `[' `{' or `begin' keyword.  Returns NIL if at top-level.*"
  (with-bp (bp (beg-line (point)) :moves)
    (let ((open (forward-up-list-or-string bp -1 nil nil))
	  (begin (PostScript-begin/end-block-start nil)))
      (if (and open begin)
	  (if (bp-< open begin) begin open)
	  (or begin open)))))


(defun 4PostScript-begin/end-block-start* (start)
  "2Search backwards from point to START for enclosing `begin' and returns a bp after it,
  or START if not found.*"
  (with-bp (bp (beg-line (point)) :moves)
    (let ((depth 1))
      (lisp:loop
	(move-bp bp (or #+EXPLORER  (fsm-search bp '#.(mapcar #'reverse '("end" "begin")) t nil)
			#+SYMBOLICS (fsm-search-within-lines
				      ;1; WMT: Symbolics 5fsm-search* won't go into reverse, so do this.*
				      ;1; This goes backwards, but finds the first occurence of 5begin* or 5end**
				      ;1; on the line instead of the last, which should be good enough.*
				      bp
				      '(("end" "begin")
					nil t)
				      t)
			(return)))
	(if (looking-at (forward-char bp -1) "end")
	    (incf depth)
	    (decf depth))
	(when (zerop depth) (return)))
      (if (not (zerop depth))
	  start
	  (forward-word bp 1)))))


(defun 4PostScript-top-level-p* ()
  "2Test to see whether we are inside some sort of PostScript block.*"
  (not (or (forward-up-list-or-string (point) -1 nil nil)
	   (PostScript-begin/end-block-start nil))))

(defvar 4*PostScript-structuring-comments* *'("%!" "%%Page:" "%%Trailer:" "%%BeginProlog:")
  "2The Structuring Comments that mark section-breaks.*")

;1;; Crudely sectionizes based on the assumption that a section begins with*
;1;; a slash or open-brace in column zero, or with a structuring-comment.*
;1;; But - an open-paren in column zero does not begin a new section if*
;1;; the immediately-previous line began with a slash.  That probably means*
;1;; we're in the midst of something like*
;1;;*	5/foo*
;1;;*	5{ ...*
;1;;*
(defun 4(:property :postscript section-p*) (line)
   (and (plusp (lisp:length line))
	(or (and (= (list-syntax (aref line 0)) list-open)
		 (or (null (line-previous line))
		     (zerop (lisp:length (line-previous line)))
		     (char-not-equal (aref (line-previous line) 0) #\/)))
	    (char-equal (aref line 0) #\/)
	    (dolist (x *PostScript-structuring-comments*)
	      (and (>= (lisp:length line) (lisp:length x))
		   (lisp:string-equal line x :end1 (lisp:length x))
		   (return t)))
	    )))

;1;; Very crudely assigns names to sections.*
;1;;*
;1;; If a line begins with 5/foo*, it is given the name 5"foo"*, making the asumption that*
;1;; we will see a lot of text of the form*
;1;;*
;1;;* 1 * 5/myproc { foo bar baz } def*
;1;; or*
;1;;   5/myproc**
;1;;     5{ foo bar baz }**
;1;;   5def**
;1;;*
;1;; If we see a 5[* or 5{* in column zero, we name the section 5"--array--"* or 5"--proc--"**
;1;; respectively.  It would be nice if we could get a section that looked like*
;1;;  * 5{ foo bar baz }*
;1;;*  1 5{ iky iky kafang }**
;1;;*  1 5ifelse**
;1;; and name the section 5ifelse*, but oh well.*
;1;;*
(defun 4(:property :postscript get-section-name*) (line temp-bp)
  (declare (string line))
  (cond ((plusp (line-length line))
	 (cond ((char-equal (aref line 0) #\/)
		(let* ((bp (forward-atom (move-bp temp-bp line 1)))
		       ;(bp (forward-atom (move-bp temp-bp line 0)))
		       (string (string-interval temp-bp bp)))
		  (values (intern string *utility-package*)   ;1 this makes 5List Sections* ugly, but makes 5Edit Definition* work.*
			  string nil)))
	       
	       ((char-equal (aref line 0) #\[)
		(values "--array--" "--array--" nil))
	       
	       ((char-equal (aref line 0) #\{)
		(values "--proc--" "--proc--" nil))
	       
	       ((char-equal (aref line 0) #\()
		(values "--3string*--" "--3string*--" nil))
	       
	       ((dolist (x *postscript-structuring-comments*)
		  (and (>= (lisp:length line) (lisp:length x))
		       (lisp:string-equal line x :end1 (lisp:length x))
		       (return t)))
		(let ((s (lisp:copy-seq line)))
		  (values s s nil)))
	       
	       (t (values nil nil t))))
	(t (values nil nil t))))


(set-comtab *zmacs-comtab* '() (make-command-alist '(com-postscript-mode)))

(lisp:pushnew '(:PS . :PostScript) fs:*file-type-mode-alist* :test #'equal)
(lisp:pushnew '(:PostScript . :PostScript) fs:*file-type-mode-alist* :test #'equal)
