;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-


(defun 4DEBUG-EN-ENABLE* (&optional pathname-or-stream)
  "2Turn on all EN debugging to a file or stream.  All debugging variables are set to t.*"
  (setf *debug-en-nntp* t)
  (debug-en-open pathname-or-stream))


(defun 4DEBUG-EN-DISABLE* ()
  "2Turn off all EN debugging.  All debugging variables are set to nil.*"
  (setf *debug-en-nntp* nil)
  (debug-en-close))


(defun 4DEBUG-EN-CLOSE* ()
  "2Close the EN debugging stream.*"
  (when (streamp *debug-en-stream*)
    (close *debug-en-stream*))
  (setf *debug-en-stream* nil))


(defun 4DEBUG-EN-OPEN* (pathname-or-stream)
  "2Open the EN debugging stream.*"
  (cond
    ((not pathname-or-stream))
    ((streamp pathname-or-stream)
     (setf *debug-en-stream* pathname-or-stream))
    (t
     (let ((pathname (pathname pathname-or-stream)))
       (setf *debug-en-stream* (fs:open pathname :direction :output))))))


(defun 4DEBUG-EN-PRINT* (format-string &rest format-args)
  "2Print format-string to the debug stream.*"
  (cond
    ((streamp *debug-en-stream*)
     (apply #'format *debug-en-stream* format-string format-args))
    (t
     (apply #'format *query-io* format-string format-args))))


(defun 4DESCRIBE-NEWSGROUP* (newsgroup)
  "2Describe newsgroup.  Return the newsgroup-component.*"
  (let ((newsgroup-component (get-newsgroup-component newsgroup)) (*print-array* t))
    (describe newsgroup-component)
    newsgroup-component))


(defun 4LIST-ALL-NEWSGROUP-COMPONENTS* ()
  "2Produce a formatted listing of all the newsgroup components from the the newsgroup component table.*"
  (let ((count 0))
  (declare (special count))
  (maphash #'(lambda (key entry)
	       (declare (ignore key))
	       (declare (special count))
	       (format t "~%~a ~30t high = ~a ~45t low = ~a ~60t mod. = ~a~70t newsrc = ~a"
		       (send entry :newsgroup-string)
		       (send entry :high-article-number)
		       (send entry :low-article-number)
		       (send entry :moderated)
		       (send entry :newsrc-p))
	       (incf count))
	   *newsgroup-component-table*)
  (format t "~%Count = ~d" count)))
