;; -*- Mode: COMMON-LISP; Fonts: (MEDFNT medfntb HL12B HL12BI cptfont1b*); Package: USER; Base: 10 -*-

;1;; This program is used to translate a resource font file from a*
;1;; Macintosh into an Explorer font file.  *


(DEFVAR 4DEBUG-ENABLED* NIL)
(DEFVAR 4DEFAULT-MAC-FILE-TYPE* "3MACFONT*")
(DEFVAR 4DEFAULT-MAC-DIRECTORY* 
        (FS:MAKE-PATHNAME :HOST "3LM*" :DIRECTORY '("3HYDE*" "3MAC-FONTS*"))
  "2Default directory for reading and writing bitmap files.*")

(DEFVAR 4MAC-PRINTER* "3TALARIS*")

(DEFVAR 4FONT-TYPE*          NIL)
(DEFVAR 4FIRST-CHAR*         NIL)
(DEFVAR 4LAST-CHAR*          NIL)
(DEFVAR 4WIDTH-MAX*          NIL)
(DEFVAR 4KERN-MAX*           NIL)
(DEFVAR 4NEGATIVE-DESCENT*   NIL)
(DEFVAR 4FONT-RECTANGLE-MAX* NIL)
(DEFVAR 4CHAR-HEIGHT*        NIL)
(DEFVAR 4OW-TABLE-LOC*       NIL)
(DEFVAR 4ASCENT*             NIL)
(DEFVAR 4DESCENT*            NIL)
(DEFVAR 4LEADING*            NIL)
(DEFVAR 4ROW-WORDS*          NIL)
(DEFVAR 4BIT-IMAGE*          NIL)
(DEFVAR 4OW-TABLE*           NIL)
(DEFVAR 4LOC-TABLE*          NIL)

(DEFUN 4word-flip* (word &aux flipped-word)
  "2Takes a WORD with bits ordered 0123...14 15 and changes their order to be 15 14...3210.*"
  ;1; Note that this is quite slow, but it doesn't matter since it is*
  ;1; only used to initialize an array.*
  (SETQ flipped-word 0)
  (DOTIMES (low-to-high 16.)
    (INCF flipped-word flipped-word)
    (IF (LOGBITP low-to-high word)
        (INCF flipped-word)))
  flipped-word)


(DEFVAR 4WORDS-FLIPPED* (MAKE-ARRAY (EXPT 2 16.) :element-TYPE '(unsigned-byte 16))
  "2This is an array of WORDS with the WORDS flipped from low-to-high to high-to-low.*")


(DEFUN 4make-words-flipped* ()
  "2Initializes the WORDS-FLIPPED array.*"
  (DOTIMES (index 65536)		   ;1 (EXPT 2 16.)*
    (SETF (AREF words-flipped index)
	  (word-flip index))))

(make-words-flipped)

(DEFVAR 4CURRENT-ADDRESS* 0)

(DEFUN 4mac* (&optional (filename "3GENEVA9*"))
  (LET* ((PATHNAME (fs:merge-pathname-defaults filename default-mac-directory default-mac-file-type))
         (file-name-component (SEND pathname :name))
         font-name
         (font-counter 1)
         max-address)
    (WITH-OPEN-FILE (mac-stream pathname :direction :input :characters nil :byte-size 8.)
      (SETQ current-address 0)
      ;1; Skip over the resource header stuff.*
      (DOTIMES (skip-count 2)
        (read-word mac-stream))
      (SETQ max-address (+ (* (read-word mac-stream) (EXPT 2 16.)) (read-word mac-stream)))
      ;1; Hack alert!  There are 2 fonts which have less in the front of them.*
      (DOTIMES (skip-count (+ #x7e (IF (OR (STRING-EQUAL file-name-component "3MONACO*")
                                           (STRING-EQUAL file-name-component "3PRINCETON*"))
				       0 2)))
        (read-word mac-stream))
      (LOOP until (>= current-address max-address)
            do
            (PROGN
              ;1; Read in the header information for the font.*
              (FORMAT t "3Translating font ~A-~D, Current address=~16R, *"
                      file-name-component font-counter current-address)
              (SETQ font-type (read-word mac-stream))
              ;1; Validate the font type.*
              (WHEN (NOT (= font-type #x9000))
                (FORMAT t "3Unknown font type ~16R.  Attempting to locate it...*" font-type)
                ;1; Didn't have the correct font type.  Sometimes*
                ;1; it is nearby.  Try reading ahead a bit to locate it.*
                (UNLESS (DOTIMES (i 5000.)
                          (SETQ font-type (read-word mac-stream))
                          (WHEN (= font-type #x9000)
                            (FORMAT t "3~%Font type located after skipping ~D words, continuing.~%*" i)
                            (RETURN t))
                          nil)
                  (FERROR nil "3~%Unknown font type.  Unable to resynchronize.*" font-type)))
              (SETQ first-char         (read-word mac-stream)      last-char          (read-word mac-stream)
                    width-max          (read-word mac-stream)      kern-max           (read-word mac-stream)
                    negative-descent   (read-word mac-stream)      font-rectangle-max (read-word mac-stream)
                    char-height        (read-word mac-stream)      ow-table-loc       (read-word mac-stream)
                    ascent             (read-word mac-stream)      descent            (read-word mac-stream)
                    leading            (read-word mac-stream)      row-words          (read-word mac-stream))
              (FORMAT t "3Height=~D~%*" char-height)
              ;1; The character bitmap follows.  Create one that is just large enough.*
              (SETQ bit-image (tv:make-sheet-bit-array tv:default-screen (* row-words 16.) char-height))
              (LET ((16b-array (MAKE-ARRAY (* row-words char-height)
                                           :element-type '(unsigned-byte 16) :displaced-to bit-image)))
                (DOTIMES (row-index char-height)
                  (DOTIMES (column-index row-words)
                    (SETF (AREF 16b-array (+ (* row-words row-index) column-index))
			  (AREF words-flipped (read-word mac-stream))))))
              (SETQ font-name (form-characters
                                mac-stream
                                (STRING-APPEND file-name-component
                                               (FORMAT nil "3-~D*" font-counter))))
              (recalculate-widths mac-stream font-name)
              (INCF font-counter)
              ;1; Skip over the header stuff for the next font*
              (FORMAT t "3Header address=~16R, data=*" current-address)
              (LET ((old-debug-enabled debug-enabled))
                (SETQ debug-enabled t)
                (read-word mac-stream)	   ;1 Skip flag indicator (x14 or xD)*
                (LOOP until (NOT (ZEROP (read-word mac-stream))))
                (SETQ debug-enabled old-debug-enabled))
              (FORMAT t "3~%*"))))
    (1- font-counter)))

(DEFUN 4read-word* (STREAM)
  "2Read in a single word, performing byte swaps as necessary.*"
  (LET ((byte-1 (SEND stream :tyi))
        (byte-2 (SEND stream :tyi))
        temp)
    (SETQ temp (DPB byte-1 (BYTE 8 8) byte-2))
    (INCF current-address 2)
    (WHEN debug-enabled
      ;1;(FORMAT T "(~16,2,48R ~16,2,48R)=~16,4,48R, " BYTE-1 BYTE-2 TEMP))*
      (FORMAT t "3~16,4,48R *" temp))
    temp))

(DEFUN 4multiple-32* (width)
  "2Make sure that WIDTH is an even multiple of 32.*"
  (1+ (DPB #o37 #o0005 width)))

(DEFVAR 4CHARACTER-MAGNIFICATION* 1)
(DEFVAR 4CHARACTER-MAGNIFICATION-BIT-IMAGE* NIL)
(DEFUN 4set-character-magnification* (magnification)
  (SETQ character-magnification magnification)
  ;1; When the magnification is 1 then we simply copy the bits*
  ;1; directly.  Otherwise we create a square array (suitable for*
  ;1; BITBLT) which we will copy to the character descriptor when*
  ;1; we see a 1 in the bit-image.*
  (WHEN (NOT (= magnification 1))
    (SETQ character-magnification-bit-image (tv:make-sheet-bit-array
                                              tv:default-screen
                                              (multiple-32 magnification)
                                              magnification
                                              :initial-element 1))))

(DEFUN 4form-characters* (STREAM font-string)
  "2Form the individual charaters given the bitmap.*"
  (LET* ((font-symbol (INTERN font-string "3FONTS*"))
					   ;1(FONT-NAME   (EVAL FONT-SYMBOL))*
         font-desc
         (last-location 0)
         this-location)
    ;1; Since we are defining the font, we need to create a font descriptor from scratch.*
    (SETQ font-desc (fed:make-font-descriptor :make-array (:type 'art-q :length (1+ last-char))))
    (SETQ last-location (read-word stream))
    (LOOP for character from first-char to last-char
          do
          (PROGN
            (SETQ this-location (read-word stream))
            ;1; Hack alert: The following code gets around a*
            ;1; problem that appears to be related to VAX or Macintosh*
            ;1; transmission.  What happens is that a byte #x8d*
            ;1; is translated to #x0d.  This code checks for the*
            ;1; error and corrects it.*
            (WHEN (AND (MINUSP (- this-location last-location)) (= (LOGAND this-location #xff) #x0d))
              (SETQ this-location (LOGIOR #x80 this-location)))
            ;1; Stuff the bits into a character descriptor.*
            (save-character character font-desc (- this-location last-location) char-height last-location)
            (SETQ last-location this-location)))
    ;1; The we have finished specifying all of the characters.*
    ;1; Store these into a font descriptor and then translate*
    ;1; that into the internal font representation.*
    (SETF (fed:fd-fill-pointer   font-desc) (1+ last-char)
          (fed:fd-name           font-desc) font-symbol
          (fed:fd-line-spacing   font-desc) (* char-height character-magnification)
          (fed:fd-baseline       font-desc) (* char-height character-magnification)
          (fed:fd-blinker-height font-desc) (* char-height character-magnification)
          (fed:fd-blinker-width  font-desc) (fed:cd-char-width (AREF font-desc (CHAR-INT #\W)))
          (fed:fd-space-width    font-desc) (fed:cd-char-width (AREF font-desc (CHAR-INT #\X))))
    (fed:font-name-set-font-and-descriptor font-symbol font-desc)
    (SETF (tv:font-char-width (EVAL font-symbol)) (fed:fd-space-width font-desc))
    ;1; Skip over the last entry in the location table.  We will*
    ;1; then be pointing to the beginning of the offset/width table.*
    (read-word stream)
    (EVAL font-symbol)))

(DEFUN 4save-character* (CHARACTER font-desc width height bit-image-x-origin)
  "2Save the character away in the font descriptor.*"
  (LET ((char-desc (fed:make-char-descriptor
		     :make-array (:type 'art-1b
					:length (LIST (* height character-magnification)
						      ;1; Make the width an even multiple of 32.*
						      (multiple-32 (* width character-magnification))))
		     cd-char-width (* width character-magnification)
		     cd-char-left-kern 0)))
    (IF (= character-magnification 1)
        (BITBLT tv:alu-ior width height bit-image bit-image-x-origin 0 char-desc 0 0)
        ;1;ELSE*
        (DOTIMES (y-index height)
          (DOTIMES (x-index width)
            (UNLESS (ZEROP (AREF bit-image y-index (+ bit-image-x-origin x-index)))
              (BITBLT tv:alu-ior character-magnification character-magnification
                      character-magnification-bit-image 0 0
                      char-desc (* character-magnification x-index) (* character-magnification y-index))))))
    (fed:fd-store-cd font-desc char-desc character)))


(DEFUN 4recalculate-widths* (STREAM font-name)
  "2Recalculate the widths based upon what is in the offset/width table*"
  (LET (offset-width-entry
        (width-table (tv:font-char-width-table font-name)))
    (LOOP for character from first-char to last-char
	  do
	  (PROGN
	    (SETQ offset-width-entry (read-word stream))
	    (SETF (AREF width-table character)
		  (IF (= offset-width-entry #xffff)
		      0
		      ;1;ELSE*
		      (* (LOGAND #xff offset-width-entry) character-magnification)) )))))

(DEFUN 4display-font* (font &optional (window tv:selected-window) (characters-per-column 32.))
  (UNLESS window
    (SETQ window tv:selected-window))
  (SEND window :select)
  (SEND window :set-cursorpos 0 0)
  (SEND window :clear-eof)
  (LET* ((font-size (IF (NOT (ZEROP (LENGTH font)))
                        (LENGTH font)
                        ;1;ELSE*
                        (LENGTH (tv:font-char-width-table font))))
         (label-font  fonts:cptfont)
         (sample-font fonts:cptfont)
         (start-x-offset  50.)
         (start-y-offset 100.)
         (x-offset-line-fudge -10.)
         (y-offset-line-fudge -10.)
         (characters-per-row (CEILING font-size characters-per-column))
         (column-increment (TRUNCATE (- (tv:sheet-width  window) start-x-offset)
                                     (* 1.05 characters-per-column)))
         (row-increment    (TRUNCATE (- (tv:sheet-height window) start-y-offset)
                                     (* 1.1 characters-per-row)))
         (CHARACTER 0)
         cursor-x cursor-y)
    ;1; Write out the name of this font*
    (SEND window :string-out-centered-explicit 
          (FORMAT nil "3~A*" (tv:font-name font))
          (tv:sheet-inside-left window) (MAX (- start-y-offset 50.) (TRUNCATE start-y-offset 2))
          (tv:sheet-inside-right window) 999. fonts:medfnb)
    ;1; Draw the label at the top.  Draw the vertical lines too.*
    (DOTIMES (column-index characters-per-column)
      (SEND window :draw-line
            (+ start-x-offset x-offset-line-fudge (* column-index column-increment))
            (+ start-y-offset y-offset-line-fudge)
            (+ start-x-offset x-offset-line-fudge (* column-index column-increment))
            (+ start-y-offset y-offset-line-fudge (* characters-per-row row-increment))
            tv:alu-ior)
      (SEND window :string-out-explicit
            (FORMAT nil "3~X*" column-index)
            (+ start-x-offset (* column-index column-increment))
            (+ start-y-offset y-offset-line-fudge  (- (tv:font-char-height label-font)))
            9999. 9999. label-font tv:alu-ior))
    ;1; Draw the rightmost vertical line.*
    (SEND window :draw-line
          (+ start-x-offset x-offset-line-fudge (* characters-per-column column-increment))
          (+ start-y-offset y-offset-line-fudge)
          (+ start-x-offset x-offset-line-fudge (* characters-per-column column-increment))
          (+ start-y-offset y-offset-line-fudge (* characters-per-row row-increment))
          tv:alu-ior)
    ;1; Draw the topmost horizontal line.*
    (SEND window :draw-line
          (+ start-x-offset x-offset-line-fudge) (+ start-y-offset y-offset-line-fudge)
          (+ start-x-offset x-offset-line-fudge (* characters-per-column column-increment))
          (+ start-y-offset y-offset-line-fudge)
          tv:alu-ior)
    ;1; Loop through all of the rows in the font.*
    (LOOP named outer
          for row-index from 0 below characters-per-row
          do
          (PROGN
            (SETQ cursor-y (+ start-y-offset (* row-index row-increment)))
            ;1; Draw a horizontal line at the bottom of this row.*
            (SEND window :draw-line
                  (+ start-x-offset x-offset-line-fudge) (+ cursor-y row-increment y-offset-line-fudge)
                  (+ start-x-offset x-offset-line-fudge (* characters-per-column column-increment))
                  (+ cursor-y row-increment y-offset-line-fudge)
                  tv:alu-ior)
            ;1; Put out the row heading.*
            (SEND window :string-out-explicit (FORMAT nil "3~16,4R *" character)
                  0 cursor-y 9999. 9999. label-font tv:alu-ior)
            ;1; Loop through all of the columns.*
            (LOOP for column-index from 0 below characters-per-column
                  do
                  (PROGN
                    (SETQ cursor-x (+ start-x-offset (* column-index column-increment)))
                    ;1; Here is where we actually draw the character.*
                    (tv:prepare-sheet (window)
                      ;1; Draw a character in the sample font above the other character.*
                      (tv:draw-char sample-font (IF (>= character (LENGTH sample-font))
                                                    (MOD character (LENGTH sample-font))
						    ;1;ELSE*
						    character)
                                    cursor-x cursor-y
                                    tv:alu-ior window)
                      (tv:draw-char font character cursor-x (+ cursor-y 3 (tv:font-char-height sample-font))
                                    tv:alu-ior window)))
                  (INCF character)
                  ;1; Get out when we don't have any more characters.*
                  (WHEN (>= character font-size)
                    (RETURN-FROM outer nil))))))
  (SEND window :set-cursorpos 0 0))

(DEFUN 4mac-and-display* (filename)
  (DOTIMES (font-index (mac filename))
    (SEND tv:selected-window :tyi)
    (display-font (EVAL (READ-FROM-STRING (FORMAT nil "3FONTS:~A-~D*"
                                                  (SEND (fs:parse-pathname filename) :name)
                                                  (1+ font-index)))))))

(DEFUN 4mac-and-print* (filename &optional (ask t))
  (LET ((old-image-printer (GET-DEFAULT-IMAGE-PRINTER))
        ch)
    (SET-DEFAULT-IMAGE-PRINTER mac-printer)
    (DOTIMES (font-index (mac filename))
      (WHEN ask
        (SEND tv:selected-window :string-out "3Press any character to display the next font chart.*")
        (SEND tv:selected-window :tyi))
      
      (display-font (EVAL (READ-FROM-STRING (FORMAT nil "3FONTS:~A-~D*"
                                                    (SEND (fs:parse-pathname filename) :name)
                                                    (1+ font-index)))))
      
      (WHEN (PROGN
              (WHEN ask
                (SEND tv:selected-window :set-cursorpos 0 0)
                (SEND tv:selected-window :string-out "3Print this font chart? [Y=yes]*")
                (SETQ ch (CHAR-INT (TYI)))
                (SEND tv:selected-window :set-cursorpos 0 0)
                (SEND tv:selected-window :clear-eol))
              (OR (NOT ask)
                  (EQL ch (CHAR-INT #\Y))
;                  (EQL ch (CHAR-INT #\Space))
		  ))
        (MULTIPLE-VALUE-BIND (left top right bottom)
            (SEND tv:selected-window :inside-edges) 
          (tv:prepare-sheet (tv:selected-window)
            (tv:mouse-warp 15. 15.)
            (PRINT-BITMAP tv:selected-window :start-x left :start-y top
                          :to-file "3LM:hyde;font-BITMAP*"
                          :width (- right left) :height (- bottom top))))))
    (SET-DEFAULT-IMAGE-PRINTER old-image-printer)))

(DEFUN 4print-font* (font)
  "2Simply print a font chart onto the Talaris.*"
  (LET ((old-image-printer (GET-DEFAULT-IMAGE-PRINTER)))
    (SET-DEFAULT-IMAGE-PRINTER mac-printer)
    (display-font font)
    (MULTIPLE-VALUE-BIND (left top right bottom)
        (SEND tv:selected-window :inside-edges) 
      (tv:prepare-sheet (tv:selected-window)
        (tv:mouse-warp 15. 15.)
        (PRINT-BITMAP tv:selected-window :start-x left :start-y top
                      :to-file "3lm:hyde;Font-Bitmap*"
                      :width (- right left) :height (- bottom top))))
    (SET-DEFAULT-IMAGE-PRINTER old-image-printer)))

(DEFUN 4print-fonts* (base-font-name font-numbers-list)
  "2Print font charts onto the Talaris.  
FONT-NUMBERS-LIST is a list of integers which indicate the fonts to print.*"
  (LET ((old-image-printer (GET-DEFAULT-IMAGE-PRINTER)))
    (SET-DEFAULT-IMAGE-PRINTER mac-printer)
    (DOLIST (font-index font-numbers-list)
      (display-font (EVAL (READ-FROM-STRING (FORMAT nil "3FONTS:~A-~D*" base-font-name font-index))))
      (MULTIPLE-VALUE-BIND (left top right bottom)
          (SEND tv:selected-window :inside-edges) 
        (tv:prepare-sheet (tv:selected-window)
          (tv:mouse-warp 15. 15.)
          (PRINT-BITMAP tv:selected-window :start-x left :start-y top
                        :to-file "3lm:hyde;Font-Bitmap*"
                        :width (- right left) :height (- bottom top)))))
    (SET-DEFAULT-IMAGE-PRINTER old-image-printer)))

(DEFUN 4mac-and-print-list* (filename-list)
  (DOLIST (filename filename-list)
    (mac-and-print filename t)))


(COMMENT
 mac-and-print-list
  '(alexis ascii12 athens bellevue boise boston_font broadway broadway24
    bubbles bubbles_2 cairo
    cairo18 carmel chicago_by_night chic_math cupertino east_orange
    elvish12 geneva gen_math greek12 hollywood laser_writer_fonts
    london london_2 long_island
    los_angeles los_angeles_2 monaco moscow new_york36
    palo_alto ravenna santiago san_francisco
    silicon_beach silicon_beach_font silicon_valley12
    ))


