;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TV; Patch-File:T -*-

;;; File "INSPECTOR-CONFIG"
;;; Defining two new inspector configurations, TALL-HISTORY and TALL-HISTORY-2.
;;; Written and maintained by Jamie Zawinski.
;;;
;;; ChangeLog:
;;;
;;; 30 Dec 88  Jamie Zawinski    Created.
;;;



(DEFMETHOD (BASIC-INSPECT-FRAME :BEFORE :INIT) (PLIST)        ;fi
  ;;Unless a higher-level :BEFORE :INIT demon has already initialized INSPECTORS, PANES, and CONSTRAINTS, initialize them.
  ;;This condition allows a superior flavor's :BEFORE :INIT demon to set them the way it wants--we don't interfere.
  (UNLESS INSPECTORS
    (LET ((NOI (OR (GET PLIST :NUMBER-OF-INSPECTORS) 3))
          (names nil)
          (iobuff (make-default-io-buffer)))
      (SETQ PANES
	    (LIST `(INTERACTOR INSPECTOR-INTERACTION-PANE
                               :LABEL NIL
                               :FONT-MAP ,(LIST (FIRST *inspector-Font-Map*))  ;(,inspect-standard-font)
                               :IO-BUFFER ,IOBUFF
                               :MORE-P NIL)
		  `(HISTORY INSPECT-HISTORY-WINDOW ;-PANE-WITH-MARGIN-SCROLLING
                            :FONT-MAP ,(LIST (FIRST *inspector-Font-Map*))
                            :IO-BUFFER ,IOBUFF)
;                            :SCROLL-BAR 3)
		  `(MENU INSPECTOR-MENU-PANE
                         :FONT-MAP ,(LIST (FIRST *inspector-Font-Map*))  ;(,inspect-standard-font)
                         :IO-BUFFER ,IOBUFF)))
      ;;Add an inspector to PANES, taking into account the number of inspector panes requested.  The first
      ;;inspector is given a typeout pane.  Also initialize INSPECTORS.
      (DOTIMES (I NOI)
	(LET ((NAME1 (INTERN (FORMAT NIL "INSPECTOR-~D" I) "TV")))
	  (PUSH
	   `(,NAME1 ,(IF (= I (1- NOI))
		       'INSPECT-PANE-WITH-TYPEOUT
		       'INSPECT-PANE)
;	     :SCROLL-BAR 2 :SCROLL-BAR-ALWAYS-DISPLAYED T
             :FONT-MAP ,(LIST (FIRST *inspector-Font-Map*)) :IO-BUFFER ,IOBUFF)
	   PANES)
          (PUSH NAME1 NAMES)))  ;?
      (SETQ INSPECTORS NAMES)   ;?
	  ;(PUSH NAME1 INSPECTORS)))
      (SETQ CONSTRAINTS
	    `((:THREE-PANES ,(REVERSE `(INTERACTOR MENU-HISTORY ,@INSPECTORS))
                    ((INTERACTOR 4 :LINES))
                    ((MENU-HISTORY :HORIZONTAL (4 :LINES HISTORY) (MENU HISTORY)
                                   ((MENU :ASK :PANE-SIZE))
                                   ((HISTORY :EVEN))))
                    ,(MAPCAR
                       #'(LAMBDA (NAME1)
                           `(,NAME1 :LIMIT (1 36 :LINES)
                             ,(/ 0.3s0 (1- NOI)) :LINES))
                       (CDR INSPECTORS))
                    ((,(CAR INSPECTORS) :EVEN)))
	      (:ONE-PANE (,(CAR INSPECTORS) MENU-HISTORY INTERACTOR)
                             ((INTERACTOR 4 :LINES))
                             ((MENU-HISTORY
                                :HORIZONTAL (4 :LINES HISTORY)
                                (MENU HISTORY)
                                ((MENU :ASK :PANE-SIZE))
                                ((HISTORY :EVEN))))
                             ((,(CAR INSPECTORS) :EVEN)))
              (:TWO-HORIZONTAL-PANES ,(REVERSE `(INTERACTOR MENU-HISTORY INSPECTOR-2 INSPECTOR-1))
                    ((INTERACTOR 4 :LINES))
                    ((MENU-HISTORY :HORIZONTAL (4 :LINES HISTORY) (MENU HISTORY)
                                   ((MENU :ASK :PANE-SIZE))
                                   ((HISTORY :EVEN))))
                    ((INSPECTOR-1 0.5))
                    ((INSPECTOR-2 :even)))
              (:TWO-VERTICAL-PANES ,(REVERSE `(INTERACTOR MENU-HISTORY SIDE-BY-SIDE))
                    ((INTERACTOR 4 :LINES))
                    ((MENU-HISTORY :HORIZONTAL (4 :LINES HISTORY) (MENU HISTORY)
                                   ((MENU :ASK :PANE-SIZE))
                                   ((HISTORY :EVEN))))
                    ((SIDE-BY-SIDE :HORIZONTAL (:even)
                                   (INSPECTOR-2 INSPECTOR-1)
                                   ((INSPECTOR-1 0.5))
                                   ((INSPECTOR-2 :even)))))
              ;;This configuration is for debugging purposes. Set *inspector-configuration* to debug. It should
              ;;not show up in profile or in the pop up config menu as a selectable configuration.
	      (:DEBUG (,(CAR INSPECTORS) MENU-HISTORY INTERACTOR)
                             ((INTERACTOR 40 :LINES))
                             ((MENU-HISTORY
                                :HORIZONTAL (4 :LINES HISTORY)
                                (MENU HISTORY)
                                ((MENU :ASK :PANE-SIZE))
                                ((HISTORY :EVEN))))
                             ((,(CAR INSPECTORS) :EVEN)))

	      ;;
	      ;; A one-pane configuration with a large history window.
	      ;;
	       (:TALL-HISTORY (,(car inspectors) HISTORY MENU-INTERACTOR)
			     ((HISTORY 15 :LINES))
			     ((MENU-INTERACTOR :HORIZONTAL (4 :LINES INTERACTOR)
					       (MENU INTERACTOR)
					       ((MENU :ASK :PANE-SIZE))
					       ((INTERACTOR :EVEN))))
			     ((,(car inspectors) :EVEN)))
	       
	      ;;
	      ;; A two-pane configuration with a large history window.
	      ;;
	       (:TALL-HISTORY-2 (,(cadr inspectors) ,(car inspectors) HISTORY MENU-INTERACTOR)
			     ((HISTORY 15 :LINES))
			     ((MENU-INTERACTOR :HORIZONTAL (4 :LINES INTERACTOR)
					       (MENU INTERACTOR)
					       ((MENU :ASK :PANE-SIZE))
					       ((INTERACTOR :EVEN))))
			     ((,(cadr inspectors) 10 :LINES))
			     ((,(car inspectors)  :EVEN)))
	       
	       )))))


(DEFCOMMAND TOGGLE-CONFIG-CMD NIL
            '(:DESCRIPTION  "Select a new inspector pane configuration."  :NAMES
             ("Config") :KEYS (#\s-C))
            (DECLARE (SPECIAL FRAME))
            (LET ((new-cfg (w:menu-choose '(:three-panes :one-pane :two-horizontal-panes :two-vertical-panes
							 :tall-history :tall-history-2)
                                          :label "Choose a new inspector configuration" :scrolling-p nil)))
              (DELAYING-SCREEN-MANAGEMENT 
                (COND (new-cfg
                       (SETQ *inspector-configuration* new-cfg)
                       (SEND frame :set-configuration new-cfg))))))



(compile-flavor-methods BASIC-INSPECT-FRAME)
