;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3EDIT-NEWSRC*"*
;1;; Copyright (c) 1989 University of California, Berkeley.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    31 Aug 89*	1Jamie Zawinski*	1 Created.*
;1;;      5 Sep 89*	1Jamie Zawinski *	1 Added Sort Newsgroups and Read Newsgroup.*
;1;;*


(defmajor com-edit-4newsgroups*-mode edit-newsgroups-mode "2Edit-Newsgroups*"
  "2Setup for editing the list of newsgroups.*" ()
  (set-comtab *mode-comtab* '(#\Space com-down-real-line
			       #\S		com-edit-newsgroups-subscribe
			       #\U		com-edit-newsgroups-unsubscribe
			       #\Rubout		com-edit-newsgroups-unsubscribe
			       #\K		com-edit-newsgroups-delete
			       #\D		com-edit-newsgroups-delete
			       #\Control-K	com-edit-newsgroups-delete
			       #\Control-D	com-edit-newsgroups-delete
			       #\E 		com-edit-newsgroups-read
			       #\Help		com-edit-newsgroups-documentation
			       #\Meta-Help	com-describe-newsgroup-line
			       #\Abort		com-edit-newsgroups-abort
			       #\End		com-edit-newsgroups-exit
			       #\Q		com-edit-newsgroups-exit
			       #\s (0 #\S)
			       #\u (0 #\U)
			       #\k (0 #\K)
			       #\e (0 #\E)
			       #\d (0 #\D)
			       #\q (0 #\Q)
			       )
	      '(("3Sort Newsgroups*" . com-sort-newsgroups))
	      )
   (set-mode-line-list (append (mode-line-list) '("   End to exit, Abort to cancel"))))


(defcom com-edit-4newsgroups* "2Edit the loaded NEWSRC file.*" ()
  (kill-new-buffer-on-abort (*interval*) (edit-newsgroups))
  DIS-NONE)

(set-comtab *zmacs-comtab* () '(("3Edit Newsgroups*" . com-edit-newsgroups)))

(defun edit-4newsgroups* ()
  (let* ((*interval* (or (send self :find-special-buffer :edit-newsgroups t "3Edit-Newsgroups*" t)
			*interval*)))
    (make-buffer-read-only *interval*)
    (com-edit-newsgroups-mode)
    (edit-newsgroups-revert *interval* nil nil t)
    DIS-TEXT))

(defprop edit-4newsgroups*-mode edit-newsgroups-revert major-mode-revert-function)


(defvar 4*edit-newsgroups-fonts* *'(fonts:hl12 fonts:hl12b fonts:hl12i fonts:hl12i fonts:hl12bi))

(defun edit-4newsgroups*-revert (buffer &optional ignore ignore select-p ignore)
  (with-read-only-suppressed (buffer)
    (let* ((*interval* buffer)
	   (old-buffer)
	  (*batch-undo-save* t))
      (dolist (buf (history-list (send *window* :buffer-history)))
	(or (eq buf *interval*)
	    (return (setq old-buffer buf))))
      (delete-interval buffer)
      (discard-undo-information buffer)
      (send buffer :set-attribute :fonts *edit-newsgroups-fonts* nil)
      (change-buffer-fonts buffer (send buffer :get-attribute :fonts))
      (with-bp (bp (interval-first-bp buffer) :moves)
	(insert-moving bp #.(in-current-font "3Newsgroups:*" 4))
	(insert-moving bp #.(string-append #\Newline #\Newline))
	(dolist (group *newsrc-list*)
	  (insert-edit-newsgroup-line bp group)))
      (move-bp (point) (beg-line (interval-first-bp buffer) 2 t))))
  (when select-p
    (make-buffer-current buffer)))

(defun (:property 4edit-newsgroups*-mode mouse-line-box-predicate) (line)
  (getf (line-plist line) 'NEWSGROUP))

(defun 4insert-edit-newsgroup-line *(bp newsgroup &optional into-line)
  (when into-line
    ;1; If we're rewriting an old line, make BP be at the beginning of that line, and delete the old text of the line.*
    ;1; This is better than deleting the line and then writing a new one, because the line's plist won't get munched.*
    (assert (null bp) (bp) "2Shouldn't supply both BP and INTO-LINE.*")
    (setq bp (create-bp into-line 0))
    (delete-interval bp (end-line bp)))
  (let* ((plist (and into-line (line-plist into-line)))
	 (newsgroup (getf plist 'NEWSGROUP newsgroup))
	 (name (send newsgroup :newsgroup-string))
	 (unread (send newsgroup :unread-article-count))
	 (subscribed-p (getf plist 'NEWSGROUP-SUBSCRIBED-P (send newsgroup :subscribed-p)))
	 (in-newsrc-p  (getf plist 'NEWSGROUP-NEWSRC-P     (send newsgroup :newsrc-p)))
	 (*font* (cond (subscribed-p 1)
		       (in-newsrc-p 0)
		       (t 3)))
	 (tab (tv:sheet-tab-width *window*)))
    (setf (getf (line-plist (bp-line bp)) 'NEWSGROUP) newsgroup)
    (setf (getf (line-plist (bp-line bp)) 'NEWSGROUP-SUBSCRIBED-P) subscribed-p)
    (setf (getf (line-plist (bp-line bp)) 'NEWSGROUP-NEWSRC-P) in-newsrc-p)
    (indent-to bp tab)
    (insert-moving bp (in-current-font name))
    (unless (or (null unread) (= 0 unread))
      (indent-to bp (* tab 6))
      (insert-moving bp (in-current-font (format nil "2~D unread article~:P*" unread) 3)))
    (unless into-line
      (insert-moving bp #\Newline)))
  bp)

(defun 4alter-newsgroup-line *(line)
  (with-read-only-suppressed (*interval*)
    (insert-edit-newsgroup-line nil nil line)))


(defcom com-edit-newsgroups-subscribe4 *"2Subscribe to the newsgroup represented by the current line.*" ()
  (let* ((line (bp-line (point))))
    (unless (getf (line-plist line) 'NEWSGROUP) (barf "3This line does not describe a newsgroup.*"))
    (setf (getf (line-plist line) 'NEWSGROUP-SUBSCRIBED-P) t)
    (alter-newsgroup-line line))
  dis-text)

(defcom com-edit-newsgroups-4un*subscribe4 *"2Unsubscribe to (or undelete) the newsgroup represented by the current line.*" ()
  (let* ((line (bp-line (point))))
    (unless (getf (line-plist line) 'NEWSGROUP) (barf "3This line does not describe a newsgroup.*"))
    (setf (getf (line-plist line) 'NEWSGROUP-SUBSCRIBED-P) nil)
    (setf (getf (line-plist line) 'NEWSGROUP-NEWSRC-P) t)
    (alter-newsgroup-line line))
  dis-text)

(defcom com-edit-newsgroups-4delete *"2Unsubscribe to the newsgroup represented by the current line, and remove it from your NEWSRC file.*" ()
  (let* ((line (bp-line (point))))
    (unless (getf (line-plist line) 'NEWSGROUP) (barf "3This line does not describe a newsgroup.*"))
    (setf (getf (line-plist line) 'NEWSGROUP-SUBSCRIBED-P) nil)
    (setf (getf (line-plist line) 'NEWSGROUP-NEWSRC-P) nil)
    (alter-newsgroup-line line))
  dis-text)

(defcom 4com-edit-newsgroups-abort* "2Abort out of Edit Newsgroups*" ()
  (send self :exit-special-buffer))

(defcom 4com-edit-newsgroups-exit *"2Exit the Newsgroups Editor, making your changes take effect.*" ()
  (do* ((line (bp-line (interval-first-bp *interval*)) (line-next line))
	(last-line (bp-line (interval-last-bp *interval*))))
       ((eq line last-line)
	(when (and *newsrc-changed*
		   (y-or-n-p "2The newsrc file ~a has changed, do you wish to save it now? *" *user-default-newsrc-file*))
	  (write-newsrc-file)))
    (let* ((plist (line-plist line))
	   (newsgroup (getf plist 'NEWSGROUP))
	   (subp (getf plist 'NEWSGROUP-SUBSCRIBED-P))
	   (rcp  (getf plist 'NEWSGROUP-NEWSRC-P))
	   )
      (when newsgroup
	(unless (and (eq (not subp) (not (send newsgroup :subscribed-p)))
		     (eq (not rcp)  (not (send newsgroup :newsrc-p))))
	  (send newsgroup :set-subscribed-p subp)
	  (send newsgroup :set-newsrc-p rcp)
	  (setq *newsrc-changed* t)))))
  (send self :exit-special-buffer t *interval*)
  DIS-BPS)
    

(defcom com-4edit-newsgroups*-documentation "2Print various sorts of editor documentation*" ()
  (let ((*com-documentation-alist* (cons '(#\M com-edit-newsgroups-help) *com-documentation-alist*)))
    (com-documentation)))

(defcom com-edit-4newsgroups*-help "2Explain Edit Newsgroups commands*" ()
  (format t "3You are inside Edit Newsgroups.  You are editing a list of all of the known newsgroups.
You can move around in the list with the usual cursor motion commands.*

	3S*		3Subscribe to this newsgroup, if not already subscribed.*
	3U or Rubout*	3Unsubscribe to this newsgroup, if subscribed.*
	3D or K*		3Unsubscribe to this newsgroup, and remove it from your newsrc file.*
	3E*		3Read this newsgroup now.*
	3Q or End*	3Exit the newsgroup editor, performing the changes you have specified.*
	3Meta-Help*	3Describe the newsgroup on the current line, and show what changes have*
			3been queued for it.

A newsgroup is subscribed if it appears in the font ~A.
It is unsubscribed if it appears in the font ~A.
It is not in your newsrc file if it is in the font ~A.
"*
	  (nth 1 4*edit-newsgroups-fonts**)
	  (nth 2 4*edit-newsgroups-fonts**)
	  (nth 3 4*edit-newsgroups-fonts**))
  DIS-NONE)


(defcom 4com-describe-newsgroup-line *"2Describe the current line.*" ()
  (let* ((plist (line-plist (bp-line (point))))
	 (ng (getf plist 'NEWSGROUP))
	 (q-subsp (getf plist 'NEWSGROUP-SUBSCRIBED-P))
	 (q-rcp  (getf plist 'NEWSGROUP-NEWSRC-P))
	 (real-subsp (and ng (send ng :subscribed-p)))
	 (real-rcp (and ng (send ng :newsrc-p))))
    (unless ng (barf "2This line does not describe a newsgroup.*"))
    (format t "3This line describes the newsgroup ~A:~2%*" (send ng :newsgroup-string))
    (unless (eq (not q-subsp) (not real-subsp))
      (if q-subsp
	  (format t "2When you exit the newsgroup editor, this newsgroup will be added to your subscription list.~%*")
	  (format t "2When you exit the newsgroup editor, this newsgroup will be removed from your subscription list.~%*")))
    (unless (eq (not q-rcp) (not real-rcp))
      (if q-rcp
	  (format t "2When you exit the newsgroup editor, this newsgroup will be added to your newsrc file.~%*")
	  (format t "2When you exit the newsgroup editor, this newsgroup will be removed from your newsrc file.~%*")))
    (terpri)
    (describe ng)
    DIS-NONE))


(defcom 4com-edit-newsgroups-read *"2Read this newsgroup now.*" ()
  (let* ((ng (getf (line-plist (bp-line (point))) 'NEWSGROUP)))
    (unless ng (barf "2This line does not describe a newsgroup.*"))
    (let* ((pos (position ng *newsrc-list* :test #'eq)))
      (unless pos (barf "3Can't find ~S in *newsrc-list**" ng))
      (setq *newsrc-index* pos)
      (com-newsgroup-space))))

(defcom 4com-sort-newsgroups *"2Sort the newsgroups in this buffer in alphabetical order.*" ()
  (let* ((top (do ((line (bp-line (interval-first-bp *interval*)) (line-next line)))
		  ((getf (line-plist line) 'NEWSGROUP)
		   line))))
    (flet ((tab-lessp (string1 string2)
	     "2True if string1 is string-lessp than string2, up to the first tab character after char 2.*"
	     (declare (string string1 string2)
		      (optimize speed))
	     (string-lessp string1 string2
			   :end1 (position #\Tab string1 :test #'char-equal :start 2)
			   :end2 (position #\Tab string2 :test #'char-equal :start 2))))
      (with-read-only-suppressed (*interval*)
	(sort-lines-interval #'tab-lessp (create-bp top 0) (interval-last-bp *interval*) nil))))
  DIS-TEXT)
