;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-
;;; 20-Mar-88 12:28:36, Bjrn Victor
;;; Copyright (c) 1988, Bjrn Victor, Department of Computer Systems, Uppsala University

(defsystem domain
  (:name "Domain Name System")
  (:short-name "DNS")
  (:pathname-default "DNS: DNS;")
  (:patchable "DNS: Patches;")

  (:module rfc ("DNS:RFC; RFC974.TEXT" "DNS:RFC; RFC1032.TEXT" "DNS:RFC; RFC1033.TEXT"
		"DNS:RFC; RFC1034.TEXT" "DNS:RFC; RFC1035.TEXT"))
  (:module config ("DNS:CONFIG; ASSIGNED-PORTS.TEXT"))
  (:module package ("PACKAGE"))
  (:module accessors ("ACCESSORS"))
  (:module defs ("DEFS"))
  (:module high ("HIGH"))
;  (:module cache ("CACHE"))
  (:module mini-ttl ("MINI-TTL-HANDLER"))	;This is really part of the cache module, which isn't finished.
;  (:module resolver ("RESOLVER"))

  (:auxiliary rfc)
  (:auxiliary config) 
  (:compile-load package)
  (:compile-load defs (:fasload package) (:fasload package))
  (:compile-load accessors (:fasload defs) (:fasload package))
;  (:compile-load cache (:fasload defs) (:fasload package))
  (:compile-load mini-ttl (:fasload package) (:fasload package))
  (:compile-load-init high (accessors mini-ttl) (:fasload package accessors mini-ttl))
;  (:compile-load-init resolver (cache high) (:fasload package cache high))
  )