;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3COMPILE-MACRO-CALLERS*".*
;1;; Copyright (c) 1989 University of California, Berkeley.*
;1;; Prompt for the name of a macro; recompile all forms in the current buffer which use that macro.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   18 Jan 90*	1Jamie Zawinski*	1Created.*
;1;;*


(defun 4compile-macro-callers *(macro-name &optional (*interval* *interval*))
  (resectionize-buffer *interval*)
  (let* ((done-any nil))
    (dolist (section (node-inferiors *interval*))
      (let* ((name (section-node-name section)))
	(when (and (symbolp name) (fdefinedp name))
	  (let* ((dbi (sys:get-debug-info-struct (symbol-function name)))
		 (macros (and dbi (sys:get-debug-info-field dbi :MACROS-EXPANDED))))
	    (when (member macro-name macros :test #'eq :key #'(lambda (x) (if (consp x) (car x) x)))
	      (setq done-any t)
	      (sys:file-operation-with-warnings ((and (buffer-file-id *interval*)
						      (send (send *interval* :generic-pathname) :generic-pathname))
						 :compile nil)
		(compiler:compiler-warnings-context-bind
		  (compile-print-interval section nil t t nil "2Compiling*" "2compiled.*" t t nil t))))))))
    done-any))


(defcom 4com-compile-macro-callers *"2Recompile all functions in this buffer which use a prompted-for macro.*" ()
  (let* ((spec (read-function-name "2Recompiler callers of:*" (relevant-function-name (point) nil t t t) t nil
		 "2Type the name of the macro or inline function for which you wish to recompile all callers in this buffer.*")))
    (if (compile-macro-callers spec)
	(format t "2~&Done.~%*")
	(barf "2No callers of ~S in this buffer.*" spec)))
  DIS-NONE)

(set-comtab *standard-comtab* () (make-command-alist '(com-compile-macro-callers)))
