;;; -*- Mode: Common-Lisp; Package: Zwei; Base: 10.; -*-

;;; Written 24-Apr-89 13:49:15 by DAVID,
;;; while running on Cousteau from band LOD1
;;; patched 10-Aug-89 by DAVID - line length of 0 (empty) now allowed

; adapted From files sys:zmacs;srccom.lisp and sys:zmacs;zmacs.lisp

(defcom COM-Compare-Windows "Compare buffers in two exposed windows.
Redisplays windows at point where they differ." ()
   (let* ((exposed-windows (delete nil (mapcar #'(lambda (w)
						   (when (send w :exposed-p)
						     w))
					       *window-list*)))
	  (nwindows (length exposed-windows)))
     (when (/= nwindows 2)
       (barf "~[No~;Only one~:;More than two~] window~:p displayed.  ~
	      I can't know which buffers to choose." nwindows))
     (let* ((window-1 (car exposed-windows))
	    (window-2 (cadr exposed-windows))
	    p1
	    p2)
       (do* ((point-1 (send window-1 :point) (forward-line point-1))
	     (point-2 (send window-2 :point) (forward-line point-2))
	     (line-1  (if (or (null point-1)
			      (zerop (bp-index point-1)))
			  (bp-line point-1)
			  (subseq (bp-line point-1) (bp-index point-1)))
		      (bp-line point-1))
	     (line-2  (if (or (null point-2)
			      (zerop (bp-index point-2)))
			  (bp-line point-2)
			  (subseq (bp-line point-2) (bp-index point-2)))
		      (bp-line point-2)))
	    ((or (null point-1)
		 (null point-2)
		 (not (equal line-1 line-2)))
	     (let ((nchars (min (length line-1)
				(length line-2)
				(abs (string-compare line-1 line-2)))))
	       (let ((*window* window-1))
		 (declare (special *window*))
		 (setf p1 (or point-1 (send (send *window* :interval) :last-bp)))
		 (move-bp (point) (bp-line p1) nchars))
	       (let ((*window* window-2))
		 (declare (special *window*))
		 (setf p2 (or point-2 (send (send *window* :interval) :last-bp)))
		 (move-bp (point) (bp-line p2) nchars)))))
       (redisplay window-1 :start p1)
       (redisplay window-2 :start p2)
       dis-none)))
