function y = ugauss2 (xsigma, ysigma, kx, ky)

%  Ugauss2(xsigma,ysigma,kx,ky) -- Generate a unit-area 2D gaussian envelope
%	xsigma -- standard deviation in X
%	ysigma -- standard deviation in Y
%	kx -- number of sigmas to generate in X direction [6]
%	ky -- number of sigmas to generate in Y direction [kx]

if nargin < 1,
	error ('Gauss2 requires an input sigma');
end;
if nargin < 2,
	ysigma = xsigma;
end;
if nargin < 3,
	kx = 6;
end;
if nargin < 4,
	ky = kx;
end;

c = [-kx*xsigma/2:kx*xsigma/2] .^ 2;
clen = length(c);
r = [-ky*ysigma/2:ky*ysigma/2] .^ 2;
rlen = length(r);
mat = zeros(rlen,clen);
xsq = 2 * xsigma .^ 2;
ysq = 2 * ysigma .^ 2;

for n = 1:rlen,
  mat(n,:) = c ./ xsq;
end;
for n = 1:clen,
  mat(:,n) = mat(:,n) + r' / ysq;
end;
y = exp(-(mat));
y = y / sum(sum(y));
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
