function y = try(image, rows, f)

if nargin<3,
  f = 1/4;
  ['Using frequency of ' num2str(f)]
end;

for i = rows,
  subplot(3,1,1);
  g = gabor(f);
  c = conv(g, image(i,:));
  c = c(floor(length(g)/2):floor(length(g)/2)+length(image(i,:)));
  ga=ugauss(4/6/f);
%   c2 = conv(ga, image(i,:));
%   c2 = c2(floor(length(ga)/2):floor(length(ga)/2)+length(image(i,:)-1));
%  c2 = zeros(1,length(image(i,:)));
%  for j = 1:length(image(i,:)),
%    c2(1,j) = max(image(i,max(1,j-2):min(length(image(i,:)),j+2)));
  c2 = conv2(image(i,:),ga,'same');
  p = plot ([1:length(image(i,:))],image(i,:),'r',[1:length(c2)],c2,'y');
  text (max(get(p(1),'Xdata'))-40,min(get(p(1),'Ydata'))+5,num2str(i));
  title(['Smoothed Signal (wavelength ' num2str(1/f) ')']);
  xlabel('Pixel Number');
  ylabel('Intensity');
  subplot(3,1,2);
  plot(cmod2pi(dx(angle(c))-2*pi*f));
  title('Deviations from Instantaneous frequency');
  xlabel('Pixel Number');
  ylabel('Phase Difference minus frequency');
  subplot(3,1,3);
  plot(abs(c));
  title('Scalogram Magnitude')
  xlabel('Pixel Number');
  ylabel('Magnitude');
  pause(5)
end;
end;



% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
