function y = showdspeaks(matrix,peaks, color)
%	Showdspeaks (matrix, peaks, color)
%
%		Display a disparity space and its associated peaks.  If no
%		peaks are input they will be computed using finddsmin.
%
%	See also finddsmin, mwm.

if (nargin < 1),
  error ('Showdspeaks:  must input a disparity matrix!');
end;

if (nargin < 2),
  'Computing peaks in the disparity space using finddsmin default params'
  peaks = finddsmin(matrix);
end;

if (nargin < 3),
  color = 'y';
end;

color = [color 'o'];
hold off;
m = (matrix .* (matrix > 0) + max(max(matrix)) * (matrix < 0)) .^ .3;
image(255 * m / max(max(m))); axis('xy');
hold on;
[a b] = size(peaks);

for i=1:a,
  plot([1:b],peaks(i,:),color);
end;
xlabel('Pixel Number')
ylabel('Disparity')
title('Disparity Space with Peaks')
hold off;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
