function y = scalogram(v,freqs, num_sigma, num_periods, full_scalogram)

% Scalogram(vector, freqs, num_sigma, num_periods, fullp)
%	Convolve input vector with Gabor filters.
%	Results will appear only where the convolution window completely
%	overlaps the original signal.
%
%	vector -- input scanline
%	freqs - Set of frequencies to use [1 ./ [2:length/4]]
%	num_sigma -- number of Gaussian sigmas to fit in convolution window [6]
%	num_periods -- number of wavelengths to fit in convolution window [4]

%%%  Check arguments
if nargin < 1,
  error ('scalogram:  must enter an input vector');
end;
if nargin < 3,
  num_sigma = 6;
end;
if nargin < 4,
  num_periods = 4;
end;
if nargin < 5,
  full_scalogram = 0;
end;
if nargin < 2,
  freqs = 1 ./ [2:length(v)/num_periods];
%% 	  [num_periods/length(v):num_periods/(2*length(v)):.5];
end;

[r c] = size(v);
if r ~= 1,
  v = v';
  [r c] = size(v);
end;
if r ~= 1,
  error ('scalogram:  Sorry, vector input only');
end;

num_freqs = length(freqs);
res = zeros (num_freqs, c);
v = v - sum(v)/length(v);		%%  Subtract out the DC

for f = 1:num_freqs;
  fr = freqs(f);
  g = gabor(fr,num_sigma,num_periods);
  glen = length (g);
  out = conv (g, v) ;%% ./ glen;  %% Don't divide, g is *already* normalized
  if (full_scalogram),
    lstart = (length(out) - c) / 2;
    res(f,:) = out(lstart+1 : lstart+c);
  else
    outlen = length (out);
    if glen < c,
      lstart = glen;
      res(f, 1+glen/2 : c-glen/2) = out(lstart:outlen-glen);
    end;
  end;
end;

y = res;
end;



% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
