function y = sad2 (l,r)

% Sad2 -- Compute the Sum of Absolute Differences of two translatable matrices

if nargin < 2,
	error ('You must supply a left and right image');
end;
[  row  col ] = size (l);
[ rrow rcol ] = size (r);
if (row ~= rrow | col ~= rcol),
	error ('Left and right images must have same dimensions!');
end;

%%%  Compute the error matrix.  We'll consider all possible overlapping
%%%  windows, even those that share only one row or column.  The computed
%%%  error will be normalized by the area of overlap

resrows = row+rrow-1;
rescols = col+rcol-1;
sad = zeros(resrows,rescols);
for drow = 1:resrows;
    ls = max(1,row-(drow-1));
    le = min(row,resrows-(drow-1));
    rs = max(1,drow-(row-1));
    re = min(rrow,drow);
    rowbias = 1+(le-ls);
    for dcol = 1:rescols;
	lcs = max(1,col-(dcol-1));
	lce = min(col,rescols-(dcol-1));
	rcs = max(1,dcol-(col-1));
	rce = min(rcol,dcol);
	sad(drow,dcol) = sum(sum(abs(l(ls:le,lcs:lce)-r(rs:re,rcs:rce)))) ...
			/ (rowbias*(1+lce-lcs));
    end;
end;

%%%  Find the best SAD in each column (result is which row has max)
[rowmin, rowind] = min(sad);

%%%  Find the overall best
[allmin, colind] = min(rowmin);

%%%  We have to negate here to fit the definition of disparity
y = -[rowind(colind)-row colind-col];


end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
