function y = mygif (file)
%
%	mygif(file) --- Read a GIF file and convert it to a greyscale matrix
%			Will append ".gif" to the filename if needed.
%			Values are automatically scaled to 8 bits; top value
%			will always be 255, bottom may be larger than 0.
%
%	See also  gifread.

[i, map] = gifread(file);
map = 255 * sum(map')' / 3;
[a b] = size(i);
y=zeros(a,b);
for x=1:b,
  for w=1:a,
    y(w,x) = map(i(w,x));
  end;
end;

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
