function y = mplot(a, b, c, d)
%
%	mplot({xvec, } function, mask {, color})
%
%		Plot a function in pieces.  Function may be a matrix, in which
%		case each row will be plotted separately.  xvec and mask each
%		may be either a matrix or single row.

if (nargin < 1),
  error ('mplot:  No input!')
end;

if (nargin < 2),
  error ('mplot:  Must input a vector and a mask');
end;

xvec = 1:length(a);
color = 'y';

if (nargin == 2),
  yvec = a;
  mask = b;
elseif (nargin == 3),
  if isstr(c),
    yvec = a;
    mask = b;
    color = c;
  else
    xvec = a;
    yvec = b;
    mask = c;
  end;
end;

if (nargin > 3),
  color = d;
end;

[xa xb] = size(xvec);
[ya yb] = size(yvec);
[ma mb] = size(mask);

if (xb == 1)
  xvec = xvec';
  [xa xb] = size(xvec);
end;
if (yb == 1),
  yvec = yvec';
  [ya yb] = size(yvec);
end;
if (mb == 1),
  mask = mask';
  [ma mb] = size(mask);
end;

if (ya ~= ma & ma ~= 1),
  error ('mplot: Mask must be same size as input (or a single row)');
end;
if (yb ~= mb),
  error ('mplot:  Mask must have same length as function')
end;
if (ya ~= xa & xa ~= 1),
  error ('mplot:  X vals be same size as input (or a single row)');
end;
if (yb ~= xb),
  error ('mplot:  X vals must have same length as function');
end

mask = mask == 0;

ih = ishold;
hold on;
for i = 1:ya,
  ind = [0; char2indices(mask(min(mb,i),:)); yb+1];
  li = length(ind);
  for j = 1:li-1,
    if ind(j) + 1 ~= ind(j+1),
      lo = ind(j)+1;
      hi = ind(j+1)-1;
      plot(xvec(min(xb,i),lo:hi), yvec(i,lo:hi), [color ':']);
      plot(xvec(min(xb,i),lo:hi), yvec(i,lo:hi), [color 'o']);
    end;
  end;
end;

if (ih == 0),
  hold off;
end;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
