function y = marktop (sig, thresh)
%
%	Marktop (signal,threshold) -- Mark the location and extent of a peak
%			in the input signal.  Result will be a pair of
%			numbers for each column, denoting the start and end
%			of the max region
%
%		Optional threshold can be used to allow slight deviations.

if nargin < 1,
  error ('marktop:  Must provide an input signal');
end;

if nargin < 2,
  thresh = 0;
end;

[len cols] = size(sig);
if (len == 1),
  sig = sig';
end;

[len cols] = size(sig);
if (len == 1),
  ['marktop:  Warning!  Input was a scalar!']
end;

%%%  Want to start by selecting the max and its adjacent values

if (len < 3),
  ['marktop:  Warning!  Fewer than three data points per column!']
end;

prefdiff = min(len-1, 2);	%%% Grab adjacent values

%%%  Find the max values and indices in all columns

[m,i] = max(sig);

lo = max([i-1; ones(1,length(i))]);
hi = min([i+1; len * ones(1,length(i))]);

lo = lo + ((hi-lo) < prefdiff) .* (max([ones(1,length(hi)); hi - prefdiff]) - lo);
hi = min([lo+prefdiff; len * ones(1,length(lo))]);

%%%  Extend the run as long as the second derivative is negative

for col = 1:cols,
  while ((lo(col) > 1) & (.1 * m(col) < sig(max(1,lo(col)-1),col))),
    if (thresh < sig(lo(col)+1,col) - 2 * sig(lo(col),col) + sig(lo(col)-1,col)),
	break;
    end;
    lo(col) = lo(col) - 1;
  end;
  while ((hi(col) < len) & (.1 * m(col) < sig(min(len,hi(col)+1),col))),
    if (thresh < sig(hi(col)+1,col) - 2 * sig(hi(col),col) + sig(hi(col)-1,col)),
	break;
    end;
    hi(col) = hi(col) + 1;
  end;
end;

y = [lo; hi];
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
