function y = horiz (l,r,win_size, max_disparity)

% Horiz -- Compute horizontal stereo disparity
%
%	left image
%	right image
%	win_size -- size of the square window used to validate [7]
%	max_disparity -- don't check the whole scanline, just within this area

if nargin < 2,
	error ('You must supply a left and right image');
end;
[  row  col ] = size (l);
[ rrow rcol ] = size (r);
if (row ~= rrow | col ~= rcol),
	error ('Left and right images must have same dimensions!');
end;

if nargin < 3,
	win_size = 7;
	'Using a 7x7 window for the matching'
end;

if nargin < 4,
	max_disparity = max (max (max (row, col), rrow), rcol);
end;
rwin = win_size;
cwin = win_size;

if win_size > row & win_size > col,
	error ('Window is larger than the images!');
else if (win_size > row),
	'Shrinking window height to match image size'
	rwin = row;
else if (win_size > col),
	'Squeezing window to fix image size'
	cwin = col;
end; end; end;

%%%  We'll only find disparities for the areas that are completely covered by
%%%  the windowing function

y = zeros (row-(rwin-1),(col-(cwin-1)));
for bot = rwin:row;

%%%  We'll run a window of given size all across the scanline, or up to the max
%%%  disparity.  We'll assume both cameras were pointing forward, and just
%%%  check positive disparities.

  for right = cwin:col;
    j = min(right-(cwin-1), max_disparity+1);
    res = zeros(1,j);
    for testing = max(cwin,right-max_disparity):right;
	res(j) = sum(sum(abs( ...
		  l(bot-(rwin-1):bot,right-(cwin-1):right) ...
		- r(bot-(rwin-1):bot,testing-(cwin-1):testing))));
	j = j - 1;
    end;
    [m, y(bot-(rwin-1),right-(cwin-1))] = min(res);
  end;
end;

%%%  Adjust for the fact that the index starts at 1
y = y - 1;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
