function y = halve_avg(mat)

%	halve_avg(mat)  --  Generate a 1/2-scale version of this matrix.
%		The resulting matrix will  have dimension ceil(size/2).  The
%		decimating function simply averages pairs (quads) of elements
%		when possible, and just returns the same value otherwise
%		(e.g. when at the bounds of an odd-length matrix).

[ xlen ylen ] = size (mat);

newx = ceil(xlen/2);
newy = ceil(ylen/2);

if (xlen == 1 & ylen == 1),
  y = mat;
else
  y = zeros(newx,newy);

%%%  This is a nasty hack, but it's 3am.  decimate is almost certainly a
%%%  better choice, but it's only 1d.

  for i = 1:floor(xlen/2),
    for j = 1:floor(ylen/2),
      y(i,j) = (mat(i*2-1,j*2-1) + mat(i*2,j*2-1) + ...
		mat(i*2-1,j*2)   + mat(i*2,j*2)) / 4;
  end; end;

  if newx ~= floor(xlen/2),
    for j = 1:floor(ylen/2),
      y(newx,j) = (mat(xlen,j*2-1) + mat(xlen,j*2)) / 2;
  end; end;

  if newy ~= floor(ylen/2),
    for i = 1:floor(xlen/2),
      y(i,newy) = (mat(i*2-1,ylen) + mat(i*2,ylen)) / 2;
  end; end;

  if newx ~= floor(xlen/2) & newy ~= floor(ylen/2),
    y(newx,newy) = mat(xlen,ylen);
  end;
end;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
