function y = gshift(mat, disparity)

% Gshift -- Shift an image according to the disparity.  Borders will be
%	    wrappped
%
%	mat -- Input Image
%	disparity -- Vector computed by gdisp (or other function)

if nargin < 2,
	error ('You must supply an image and disparity vector');
end;

[rows cols] = size(mat);

%%%  Take the integer part of the shift
idisp = -floor (disparity);
drow = mod (idisp(1), rows);
dcol = mod (idisp(2), cols);

%%%  Shift the rows
if (drow ~= 0),
	y = [ mat(drow+1:rows,:) ; mat(1:drow,:) ];
else,
	y = mat;
end;

%%%  Shift the columns
if (dcol ~= 0),
	y = [   y(:,dcol+1:cols)';   y(:,1:dcol)']';
end;

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
