function y = gdisp(l, r)

% Global -- Compute global shift.  Disparity is defined as LEFT-RIGHT.
%	    Uses cross-corrlation.
%
%	left  -- Left input image.  Must have same dimensions as:
%	right -- Right input image (same size as left image)

if nargin < 2,
	error ('You must supply a left and right image');
end;
[  row  col ] = size (l);
[ rrow rcol ] = size (r);
if (row ~= rrow | col ~= rcol),
	error ('Left and right images must have same dimensions!');
end;

%%%  Compute the overall global correlation coefficient matrix
corr2d = xcorr2(l,r);

%%%  Find the max correlation in each column (result is which row has max)
[rowmax, rowind] = max(corr2d);

%%%  Find the overall maximum
[allmax, colind] = max(rowmax);

y = [rowind(colind)-row colind-col];

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
