function res = fmttime (t)
%	fmttime(time)	--  Pretty-print the value of time (default now)

if nargin < 1,
  t = fix(clock);
end

[a b] = size(t);

if (b ~= 6),
  t = t';
end

if (b ~= 6 & a ~= 1),
  error ('fmttime:  need 6-element vector input, as from CLOCK');
end;

months = ...
   ['January  ';'February ';'March    ';'April    ';'May      ';'June     ';
    'July     ';'August   ';'September';'October  ';'November ';'December '];

if (t(1) < 100),
  ['fmttime: WARNING!  Year less than 100']
  if (t(1) < 40),
    t(1) = t(1) + 100;
  end;
  t(1) = t(1) + 1900;
end;

y = sprintf ('%s %s, %s  %02d:%02d.%02d', num2str(t(3)), months(t(2),:), ...
	num2str(t(1)), t(4), t(5), t(6));

[a comma_index] = min (abs(y - ','));
start = comma_index;
while (start > 1 & (y(start) == ' ' | y(start) == ',')),
  start = start - 1;
end;
res = y([1:start (comma_index+1):length(y)]);

end

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
