function [skip, x, y, color, mc] = flparse(def_color, colind, i1, i2, i3)
%
%	FLPARSE -- Map three inputs to a triple required by PLOT, returning
%		   the number of parameters parsed in the process.  Empty
%		   arguments are denoted with an empty matrix ''.
%		   This assumes that valid X specifications not only have
%		   the same length as the following Y spec, but also
%		   consist of a vector whose elements differ by exactly 1.
%
%	Used by FLPLOT.

% Written by Mark Maimone (mwm@cs.cmu.edu) on 26 August 1995
% Updated 4 September 95 (mwm@cs.cmu.edu)  Now handles matrix input.

if nargin < 1,
  def_color = 'y';
end;

% Set defaults

skip = 1;
x = 0;
y = 0;
color = def_color;
mc = 0;

% Fill in any missing arguments with an empty matrix

if nargin < 3,
  error ('Flparse: nothing to parse!');
end;
if size(i1) == [0 0],
  error ('Flparse: empty first argument!');
end;
if nargin < 5,
  i3 = '';
end;
if nargin < 4,
  i2 = '';
end;

% Put all vectors in canonical form (with length in second size() element)

l1 = size(i1);
if l1(1) > 1,
  i1 = i1';
  l1 = size(i1);
end;
l2 = size(i2);
if l2(1) > 1,
  i2 = i2';
  l2 = size(i2);
end;
l3 = size(i3);
if l3(1) > 1,
  i3 = i3';
  l3 = size(i3);
end;

% Step through a matrix using the colind (input) and mc (output) indices.

if (l1(1) > 1),
  if (colind == 0),
    colind = 1;
  end;

%%%  Matrix is first argument, shift parameters right and insert X range

  i3 = i2;
  i2 = i1(colind,:);		%%% Output COLUMN by default; I know this
				%%% is a row, i1 was transposed earlier
  i1 = [1:length(i2)];
  skip = 0;
  mc = colind+1;
  if colind >= l1(1),
    skip = 1 + (isstr(i3) & size(i3) ~= 0);
    mc = 0;
  end;
  l1 = size(i1);
  l2 = size(i2);
  l3 = size(i3);
elseif (l2(1) > 1),

%%%  Matrix is second argument

  if (colind == 0),
    colind = 1;
  end;

%%% Prefer columns, but if only the rows match go with that.

  if (l1(2) ~= l2(2) & l1(2) == l2(1)),
    i2 = i2(:,colind)';
    l2 = [l2(2) l2(1)];
  else
    i2 = i2(colind,:);
  end;
  skip = 0;
  mc = colind+1;
  if colind >= l2(1),
    skip = 2 + (isstr(i3) & size(i3) ~= 0);
    mc = 0;
  end;
  l2 = size(i2);
end;

if isstr(i1),
  error ('Flparse ERROR:  First argument is string');
end;

% Most likely case is that the X values have been omitted

if (nargin < 4) | isstr(i2) | (l1(2) ~= l2(2)) | ...
   (sum(i1(:,2:l1(2))-i1(:,1:(l1(2)-1)) == 1) ~= l2(2)-1),
  x = [1:l1(2)];
  y = i1;
  if (nargin > 3) & isstr(i2) & l2(1) > 0,
    color = i2;
    skip = 2;
  end;
else

% Otherwise the first arg is the X vector, second is Y, third is optional color

  if colind == 0,
    skip = 2;
  end;
  x = i1;
  y = i2;
  if (nargin > 4) & isstr(i3) & l3(1) > 0,
    color = i3;
    if (colind == 0),
      skip = 3;
    end;
  end;
end;

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
