function y = fleet(scalogram,freqs)

% Fleet(scalogram, freqs) -- Apply Fleet's constraint to a scalogram
%
%	abs((phi' - f) + j (a'/a) [ < threshold, e.g. .05]

if nargin < 1,
  error('You must input a scalogram');
end;

[f p] = size(scalogram);
if nargin < 2,
  'Using default frequencies (linear wavelength samples)'
  freqs = 1 ./ [2:(p/4)];
end;
freqs = -sort(-freqs);

[f1 f2] = size(freqs);
if f1 > 1,
  freqs = freqs';
  [f1 f2] = size(freqs);
end;

if f2 ~= f,
  error ('Number of frequencies does not match size of scalogram!');
end;

if p == 1,
  error ('Scalogram too small, must have at least two columns');
end;

pd = cmod2pi(dx(angle(scalogram)))-(2*pi*ones(p-1,1) * freqs)';
filter = (([pd'; zeros(1,f)]').^2 + ...
          ([ max(.001,abs(dx(abs(scalogram))))'; zeros(1,f)]' ./ ...
	  max(abs(scalogram),.001)).^2);
y = (filter);
end;


% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
