function [mean, stddev] = fitgauss (sig)
%	[mean,stddev] = fitgauss(signal) - Fit a Gaussian to the input vector.
%			This is a 1D fit; given matrix input, each column
%			will be computed independently.

% This took a while to debug.  The key is to realize that the *index* is
% the real list being analyzed.  The input   sig   simply weights the indices
% differently.  So when computing the variance, don't square the weights,
% just the indices.

if (nargin < 1),
  error('fitgauss:  must enter a signal')
end;

[len a] = size(sig);
if (len == 1),
  sig = sig';
end;
[len a] = size(sig);

ind = [1:len]';
indm = ind(:,ones(1,a));
sumit = sum(indm .* sig);
area = sum(sig);

mean = sumit ./ area;
sumsq = sum((indm .^ 2) .* sig) ./ area - mean .^ 2;

stddev = sqrt(sumsq);

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
