function y = finddsmin(matrix,a,b,c,d,e,f,g,h,i,j)
%	Finddsmin(matrix,....)    Find all the minima in a disparity space.
%				  Matrix entries less than zero will be
%				  ignored.  Same extra args as findpeaks.
%
%	See also:   findpeaks

if nargin < 1,
  error ('finddsmin:  Must input a Disparity Space matrix!');
end;

[rows cols] = size(matrix);

%%%  Our peak-finder looks for local MAXIMA, not minima.  So we have to shift
%%%  each column indepedently.  Why each column?  Because if we shift by the
%%%  global maximum, we'll skew the ratios of the peaks.

maxcols = max(matrix);
imat = (maxcols(ones(rows,1),:) -matrix) .* (matrix >= 0);

    if (nargin < 2), y = findpeaks(imat);
elseif (nargin < 3), y = findpeaks(imat,a);
elseif (nargin < 4), y = findpeaks(imat,a,b);
elseif (nargin < 5), y = findpeaks(imat,a,b,c);
elseif (nargin < 6), y = findpeaks(imat,a,b,c,d);
elseif (nargin < 7), y = findpeaks(imat,a,b,c,d,e);
elseif (nargin < 8), y = findpeaks(imat,a,b,c,d,e,f);
elseif (nargin < 9), y = findpeaks(imat,a,b,c,d,e,f,g);
elseif (nargin < 10), y = findpeaks(imat,a,b,c,d,e,f,g,h);
elseif (nargin < 11), y = findpeaks(imat,a,b,c,d,e,f,g,h,i);
elseif (nargin > 10), y = findpeaks(imat,a,b,c,d,e,f,g,h,i,j);
end;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
