function y = fcircle (a,b,c,d,e);
%	Fcircle(radius,xc,yc,xsize,ysize) -- generate a matrix containing a
%		filled-in circle with given radius.  Radius is required, other
%		parameters are optional but must be given in pairs.
%
%	See also:  circle.

if (nargin < 1),
	error ('Circle:  Must set radius!')
end;

radius = round(a);
xc = radius+1; yc = radius+1;

if (nargin == 2),
	error ('Circle:  Missing y center');
end;

if (nargin > 2),
	xc = round(b); yc = round(c);
end;

xsize = xc+radius;
ysize = yc+radius;

if (nargin == 4),
	error ('Circle:  Missing y size');
end;

if (nargin == 5),
	xsize = round(d); ysize = round(e);
end;

if (nargin > 5),
	error ('Circle:  Too many arguments!');
end;

R = zeros (ysize,xsize);

%
%  Draw a circle using Bresenham's method.  From Hearn & Baker "Computer
%  Graphics" page 69.
%

x = 0;
y = radius;
p = 3 - 2 * radius;

while (x < y),
  lx = xc-x; rx=xc+x; ny=yc+y; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
  lx = xc-x; rx=xc+x; ny=yc-y; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
  lx = xc-y; rx=xc+y; ny=yc+x; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
  lx = xc-y; rx=xc+y; ny=yc-x; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end

  if (p < 0);
    p = p + 4 * x + 6;
  else
    p = p + 4 * (x - y) + 10;
    y = y - 1;
  end;
  x = x + 1;
end;

if (x == y),
  lx = xc-x; rx=xc+x; ny=yc+y; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
  lx = xc-x; rx=xc+x; ny=yc-y; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
  lx = xc-y; rx=xc+y; ny=yc+x; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
  lx = xc-y; rx=xc+y; ny=yc-x; lm = max(lx,1); rm = min(rx,xsize);
  if (rx>0 & lx<=xsize & ny>0 & ny<=ysize), R(ny,lm:rm)=ones(1,(rm-lm)+1);end
end;

y = R;
end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
