function y = colextract(mat, rowis)
%
%	colextract(matrix,rowindices) -- Extract named indices from columns;
%					 number of indices must == matrix cols

[a b] = size(mat);
[c d] = size(rowis);

if b ~= d,
  error('colextract:  number of indices must equal number of matrix columns')
end;

y = zeros(c,d);
for i = 1:b,
  for j = 1:c,
    if rowis(j,i) >= 1 & rowis(j,i) < a,
      y(j,i) = mat(rowis(j,i),i);
  end;
end;

end;

% This software provided by Mark Maimone (mwm@cmu.edu) as part of his Ph.D.
% thesis.  For more info, please see http://www.cs.cmu.edu/~mwm/thesis
%
% Release Date: 9 October 1997
%
% 	Carnegie Mellon University and the individuals associated with this
% project assume no liability for the fitness or performance of this software
% or any damages resulting from its use.  It's free, you get what you pay
% for...
