/*
 * Decompiled with CFR 0.152.
 */
package will.tetris;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import will.ClosableJFrame;
import will.JBackgroundPanel;
import will.Timer;
import will.TimerEvent;
import will.TimerListener;
import will.tetris.BlockGraphics;
import will.tetris.ComputerPlayer;
import will.tetris.DropPane;
import will.tetris.HumanPlayer;
import will.tetris.KeyboardPlayer;
import will.tetris.NextBlockPane;
import will.tetris.RandomComputer;
import will.tetris.ScorePane;

public class game
implements Runnable,
TimerListener {
    static final int width = 10;
    static final int height = 20;
    static final long repaintDelay = 20L;
    static final String pictDir = "/pictures/";
    static final String BackGroundPicName = "sam-will.jpeg";
    ClosableJFrame myFrame;
    DropPane dPane;
    NextBlockPane nPane;
    ScorePane sPane;
    BlockGraphics myBlocks;
    Timer myTimer;
    ComputerPlayer comp;
    HumanPlayer human;
    JBackgroundPanel Background;
    int[][] blocks;
    int currentBlock;
    int nextBlock;
    int currentX;
    int currentY;
    int currentRot;
    int RowsDeleted;

    public game() {
        int left;
        Toolkit myKit = Toolkit.getDefaultToolkit();
        this.myFrame = new ClosableJFrame("Tetris");
        this.myFrame.pack();
        Container contentPane = this.myFrame.getContentPane();
        this.myBlocks = new BlockGraphics(this.myFrame);
        URL resource = this.getClass().getResource("/pictures/sam-will.jpeg");
        this.Background = new JBackgroundPanel(myKit.getImage(resource));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(4, 4, 4, 4);
        this.Background.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.7;
        this.sPane = new ScorePane(this);
        gridbag.setConstraints(this.sPane, c);
        this.Background.add(this.sPane);
        c.weighty = 1.0;
        c.gridy = 1;
        c.anchor = 11;
        this.nPane = new NextBlockPane(this);
        gridbag.setConstraints(this.nPane, c);
        this.Background.add(this.nPane);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.anchor = 10;
        this.dPane = new DropPane(this);
        gridbag.setConstraints(this.dPane, c);
        this.Background.add(this.dPane);
        this.myTimer = new Timer();
        this.myTimer.addTimerListener(this);
        contentPane.add(this.myTimer);
        contentPane.add(this.Background);
        this.Background.revalidate();
        this.myFrame.pack();
        this.myFrame.setResizable(false);
        Dimension screenSize = this.myFrame.getToolkit().getScreenSize();
        Dimension windSize = this.myFrame.getSize();
        int top = (screenSize.height - windSize.height - 50) / 2;
        if (top < 0) {
            top = 0;
        }
        if ((left = (screenSize.width - windSize.width - 10) / 2) < 0) {
            left = 0;
        }
        ((Component)this.myFrame).setLocation(left, top);
        this.blocks = new int[20][10];
        int y = 0;
        while (y < 20) {
            int[] row = this.blocks[y];
            int x = 0;
            while (x < 10) {
                row[x] = -1;
                ++x;
            }
            ++y;
        }
        this.comp = new RandomComputer();
        this.currentBlock = this.comp.getNextBlock(this);
        this.nextBlock = this.comp.getNextBlock(this);
        this.currentX = this.comp.getXPosn(this);
        this.currentY = 0;
        this.myTimer.setInterval(this.comp.getTimerInterval(this));
        this.human = new KeyboardPlayer(this);
        this.RowsDeleted = 0;
    }

    boolean ValidPosition(int blockID, int x, int y, int rot, boolean checkTop) {
        int[][] defn = BlockGraphics.blockDefn[blockID][rot];
        int i = 0;
        while (i < defn.length) {
            int sx = x + defn[i][0];
            int sy = y - defn[i][1];
            if (sx < 0 || sx >= 10) {
                return false;
            }
            if (checkTop && sy < 0 || sy >= 20) {
                return false;
            }
            if (sy >= 0 && this.blocks[sy][sx] != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void gameOver() {
        this.myTimer.stop();
    }

    void stop() {
        this.myTimer.stop();
        this.myFrame.dispose();
    }

    void HitBottom() {
        int[][] defn = BlockGraphics.blockDefn[this.currentBlock][this.currentRot];
        if (!this.ValidPosition(this.currentBlock, this.currentX, this.currentY, this.currentRot, true)) {
            this.gameOver();
            return;
        }
        int i = 0;
        while (i < defn.length) {
            int sx = this.currentX + defn[i][0];
            int sy = this.currentY - defn[i][1];
            this.blocks[sy][sx] = this.currentBlock;
            ++i;
        }
        int y = 0;
        while (y < 20) {
            int[] row = this.blocks[y];
            boolean full = true;
            int x = 0;
            while (x < 10) {
                if (row[x] < 0) {
                    full = false;
                    break;
                }
                ++x;
            }
            if (full) {
                int x2 = 0;
                while (x2 < 10) {
                    row[x2] = -1;
                    ++x2;
                }
                System.arraycopy(this.blocks, 0, this.blocks, 1, y);
                this.blocks[0] = row;
                ++this.RowsDeleted;
                this.sPane.updateScore();
            }
            ++y;
        }
        this.currentBlock = this.nextBlock;
        this.nextBlock = this.comp.getNextBlock(this);
        this.currentX = this.comp.getXPosn(this);
        this.currentY = 0;
        this.currentRot = 0;
        this.myTimer.setInterval(this.comp.getTimerInterval(this));
        this.Background.repaint(20L);
    }

    void DropBlockOneRow() {
        if (this.ValidPosition(this.currentBlock, this.currentX, this.currentY + 1, this.currentRot, false)) {
            Rectangle repaintRect = this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot);
            ++this.currentY;
            repaintRect = repaintRect.union(this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot));
            Rectangle dBounds = this.dPane.getBounds();
            this.Background.repaint(20L, repaintRect.x + dBounds.x, repaintRect.y + dBounds.y, repaintRect.width, repaintRect.height);
        } else {
            this.HitBottom();
        }
    }

    void DropBlockToBase() {
        while (this.ValidPosition(this.currentBlock, this.currentX, this.currentY + 1, this.currentRot, false)) {
            Rectangle repaintRect = this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot);
            ++this.currentY;
            repaintRect = repaintRect.union(this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot));
            Rectangle dBounds = this.dPane.getBounds();
            this.Background.repaint(20L, repaintRect.x + dBounds.x, repaintRect.y + dBounds.y, repaintRect.width, repaintRect.height);
        }
        this.HitBottom();
    }

    public void timerFired(TimerEvent evt) {
        this.DropBlockOneRow();
    }

    public void MoveLeft() {
        if (this.ValidPosition(this.currentBlock, this.currentX - 1, this.currentY, this.currentRot, false)) {
            Rectangle repaintRect = this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot);
            --this.currentX;
            repaintRect = repaintRect.union(this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot));
            Rectangle dBounds = this.dPane.getBounds();
            this.Background.repaint(20L, repaintRect.x + dBounds.x, repaintRect.y + dBounds.y, repaintRect.width, repaintRect.height);
        }
    }

    public void MoveRight() {
        if (this.ValidPosition(this.currentBlock, this.currentX + 1, this.currentY, this.currentRot, false)) {
            Rectangle repaintRect = this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot);
            ++this.currentX;
            repaintRect = repaintRect.union(this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot));
            Rectangle dBounds = this.dPane.getBounds();
            this.Background.repaint(20L, repaintRect.x + dBounds.x, repaintRect.y + dBounds.y, repaintRect.width, repaintRect.height);
        }
    }

    public void RotateLeft() {
        int newRot = (this.currentRot + 1) % 4;
        if (this.ValidPosition(this.currentBlock, this.currentX, this.currentY, newRot, false)) {
            Rectangle repaintRect = this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot);
            this.currentRot = newRot;
            repaintRect = repaintRect.union(this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot));
            Rectangle dBounds = this.dPane.getBounds();
            this.Background.repaint(20L, repaintRect.x + dBounds.x, repaintRect.y + dBounds.y, repaintRect.width, repaintRect.height);
        }
    }

    public void RotateRight() {
        int newRot = (this.currentRot - 1 + 4) % 4;
        if (this.ValidPosition(this.currentBlock, this.currentX, this.currentY, newRot, false)) {
            Rectangle repaintRect = this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot);
            this.currentRot = newRot;
            repaintRect = repaintRect.union(this.myBlocks.getBlockRect(this.currentBlock, this.currentX, this.currentY, this.currentRot));
            Rectangle dBounds = this.dPane.getBounds();
            this.Background.repaint(20L, repaintRect.x + dBounds.x, repaintRect.y + dBounds.y, repaintRect.width, repaintRect.height);
        }
    }

    public void run() {
        this.myFrame.show();
        this.myTimer.start();
        this.myTimer.setEnabled(false);
        this.Background.repaint(20L);
    }
}

