/*
 * Decompiled with CFR 0.152.
 */
package will.tetris;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import will.shouldntGetHereException;

class BlockGraphics {
    protected Frame myFrame;
    public static final int numBlocks = 7;
    public static final int numRots = 4;
    protected Image[] rawBlocks;
    protected static final String[] blockNames = new String[]{"Blue.gif", "Red.gif", "Green.gif", "Grey.gif", "Yellow.gif", "White.gif", "Grey.gif"};
    protected static final String pictDir = "/pictures/";
    public final int baseWidth;
    public final int baseHeight;
    private static final int[][][] baseBlockDefns;
    protected static final int[][][] rotDelta;
    protected static final int[][] rotMult;
    public static final int[][][][] blockDefn;

    public BlockGraphics(Frame theFrame) {
        this.myFrame = theFrame;
        this.rawBlocks = new Image[blockNames.length];
        MediaTracker myTracker = new MediaTracker(theFrame);
        Toolkit myKit = Toolkit.getDefaultToolkit();
        int i = 0;
        while (i < blockNames.length) {
            String thisName = pictDir + blockNames[i];
            URL resource = this.getClass().getResource(thisName);
            this.rawBlocks[i] = myKit.getImage(resource);
            if (this.rawBlocks[i] == null) {
                throw new shouldntGetHereException("Unable to load image: " + thisName);
            }
            theFrame.prepareImage(this.rawBlocks[i], null);
            myTracker.addImage(this.rawBlocks[i], i);
            ++i;
        }
        try {
            myTracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new shouldntGetHereException(e);
        }
        this.baseWidth = this.rawBlocks[0].getWidth(null) - 1;
        this.baseHeight = this.rawBlocks[0].getHeight(null) - 1;
    }

    public void DrawSquare(int colour, int x, int y, Graphics g) {
        this.DrawSquare(colour, x, y, g, 0, 0);
    }

    public void DrawSquare(int colour, int x, int y, Graphics g, int translateLeft, int translateTop) {
        Image img = this.rawBlocks[colour];
        g.drawImage(img, x * this.baseWidth + translateLeft, y * this.baseHeight + translateTop, null);
    }

    public void DrawBlock(int blockID, int x, int y, int rot, Graphics g) {
        this.DrawBlock(blockID, x, y, rot, g, 0, 0);
    }

    public void DrawBlock(int blockID, int x, int y, int rot, Graphics g, int translateLeft, int translateTop) {
        int[][] defn = blockDefn[blockID][rot];
        int i = 0;
        while (i < defn.length) {
            this.DrawSquare(blockID, x + defn[i][0], y - defn[i][1], g, translateLeft, translateTop);
            ++i;
        }
    }

    public Rectangle getBlockRect(int blockID, int x, int y, int rot) {
        int[][] defn = blockDefn[blockID][rot];
        Rectangle result = null;
        int i = 0;
        while (i < defn.length) {
            result = result == null ? new Rectangle((x + defn[i][0]) * this.baseWidth, (y - defn[i][1]) * this.baseHeight, this.baseWidth + 1, this.baseHeight + 1) : result.union(new Rectangle((x + defn[i][0]) * this.baseWidth, (y - defn[i][1]) * this.baseHeight, this.baseWidth + 1, this.baseHeight + 1));
            ++i;
        }
        return result;
    }

    static {
        int[][][] nArrayArray = new int[7][][];
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[2];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray2[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray2[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        nArrayArray2[3] = nArray3;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        nArrayArray3[0] = new int[2];
        int[] nArray4 = new int[2];
        nArray4[0] = 1;
        nArrayArray3[1] = nArray4;
        nArrayArray3[2] = new int[]{1, 1};
        nArrayArray3[3] = new int[]{1, 2};
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        int[] nArray5 = new int[2];
        nArray5[1] = 1;
        nArrayArray4[0] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 2;
        nArrayArray4[1] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[0] = 1;
        nArrayArray4[2] = nArray7;
        nArrayArray4[3] = new int[]{1, 1};
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[4][];
        nArrayArray5[0] = new int[2];
        int[] nArray8 = new int[2];
        nArray8[1] = 1;
        nArrayArray5[1] = nArray8;
        nArrayArray5[2] = new int[]{1, 1};
        nArrayArray5[3] = new int[]{1, 2};
        nArrayArray[3] = nArrayArray5;
        int[][] nArrayArray6 = new int[4][];
        nArrayArray6[0] = new int[2];
        int[] nArray9 = new int[2];
        nArray9[1] = 1;
        nArrayArray6[1] = nArray9;
        int[] nArray10 = new int[2];
        nArray10[0] = 1;
        nArrayArray6[2] = nArray10;
        nArrayArray6[3] = new int[]{1, 1};
        nArrayArray[4] = nArrayArray6;
        int[][] nArrayArray7 = new int[4][];
        nArrayArray7[0] = new int[2];
        int[] nArray11 = new int[2];
        nArray11[1] = 1;
        nArrayArray7[1] = nArray11;
        int[] nArray12 = new int[2];
        nArray12[1] = 2;
        nArrayArray7[2] = nArray12;
        int[] nArray13 = new int[2];
        nArray13[1] = 3;
        nArrayArray7[3] = nArray13;
        nArrayArray[5] = nArrayArray7;
        int[][] nArrayArray8 = new int[4][];
        int[] nArray14 = new int[2];
        nArray14[0] = -1;
        nArrayArray8[0] = nArray14;
        nArrayArray8[1] = new int[2];
        int[] nArray15 = new int[2];
        nArray15[0] = 1;
        nArrayArray8[2] = nArray15;
        int[] nArray16 = new int[2];
        nArray16[1] = 1;
        nArrayArray8[3] = nArray16;
        nArrayArray[6] = nArrayArray8;
        baseBlockDefns = nArrayArray;
        int[][][] nArrayArray9 = new int[7][][];
        int[][] nArrayArray10 = new int[4][];
        nArrayArray10[0] = new int[2];
        int[] nArray17 = new int[2];
        nArray17[0] = 1;
        nArrayArray10[1] = nArray17;
        nArrayArray10[2] = new int[]{1, 1};
        int[] nArray18 = new int[2];
        nArray18[1] = 1;
        nArrayArray10[3] = nArray18;
        nArrayArray9[0] = nArrayArray10;
        int[][] nArrayArray11 = new int[4][];
        nArrayArray11[0] = new int[2];
        int[] nArray19 = new int[2];
        nArray19[0] = 1;
        nArrayArray11[1] = nArray19;
        nArrayArray11[2] = new int[]{1, 1};
        int[] nArray20 = new int[2];
        nArray20[1] = 1;
        nArrayArray11[3] = nArray20;
        nArrayArray9[1] = nArrayArray11;
        int[][] nArrayArray12 = new int[4][];
        nArrayArray12[0] = new int[2];
        int[] nArray21 = new int[2];
        nArray21[0] = 1;
        nArrayArray12[1] = nArray21;
        nArrayArray12[2] = new int[]{1, 1};
        int[] nArray22 = new int[2];
        nArray22[1] = 1;
        nArrayArray12[3] = nArray22;
        nArrayArray9[2] = nArrayArray12;
        int[][] nArrayArray13 = new int[4][];
        nArrayArray13[0] = new int[2];
        int[] nArray23 = new int[2];
        nArray23[0] = 1;
        nArrayArray13[1] = nArray23;
        nArrayArray13[2] = new int[]{1, 1};
        int[] nArray24 = new int[2];
        nArray24[1] = 1;
        nArrayArray13[3] = nArray24;
        nArrayArray9[3] = nArrayArray13;
        int[][] nArrayArray14 = new int[4][];
        nArrayArray14[0] = new int[2];
        int[] nArray25 = new int[2];
        nArray25[0] = 1;
        nArrayArray14[1] = nArray25;
        nArrayArray14[2] = new int[]{1, 1};
        int[] nArray26 = new int[2];
        nArray26[1] = 1;
        nArrayArray14[3] = nArray26;
        nArrayArray9[4] = nArrayArray14;
        int[][] nArrayArray15 = new int[4][];
        nArrayArray15[0] = new int[2];
        nArrayArray15[1] = new int[]{1, 1};
        int[] nArray27 = new int[2];
        nArray27[1] = 3;
        nArrayArray15[2] = nArray27;
        nArrayArray15[3] = new int[]{-2, 1};
        nArrayArray9[5] = nArrayArray15;
        nArrayArray9[6] = new int[][]{new int[2], new int[2], new int[2], new int[2]};
        rotDelta = nArrayArray9;
        int[][] nArrayArray16 = new int[4][];
        int[] nArray28 = new int[4];
        nArray28[0] = 1;
        nArray28[2] = 1;
        nArrayArray16[0] = nArray28;
        int[] nArray29 = new int[4];
        nArray29[1] = -1;
        nArray29[3] = 1;
        nArrayArray16[1] = nArray29;
        int[] nArray30 = new int[4];
        nArray30[0] = -1;
        nArray30[2] = -1;
        nArrayArray16[2] = nArray30;
        int[] nArray31 = new int[4];
        nArray31[1] = 1;
        nArray31[3] = -1;
        nArrayArray16[3] = nArray31;
        rotMult = nArrayArray16;
        blockDefn = new int[7][][][];
        int block = 0;
        while (block < 7) {
            int[][] defn = baseBlockDefns[block];
            BlockGraphics.blockDefn[block] = new int[4][defn.length][2];
            int rot = 0;
            while (rot < 4) {
                int i = 0;
                while (i < defn.length) {
                    BlockGraphics.blockDefn[block][rot][i][0] = rotDelta[block][rot][0] + rotMult[rot][0] * defn[i][0] + rotMult[rot][1] * defn[i][1];
                    BlockGraphics.blockDefn[block][rot][i][1] = rotDelta[block][rot][1] + rotMult[rot][2] * defn[i][1] + rotMult[rot][3] * defn[i][0];
                    ++i;
                }
                ++rot;
            }
            ++block;
        }
    }
}

