/*
 * Decompiled with CFR 0.152.
 */
package will;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Vector;
import will.TimerEvent;
import will.TimerListener;

public class Timer
extends Component
implements Runnable {
    protected long interval;
    protected Thread myThread;
    protected boolean enabled;
    protected boolean daemon;
    protected boolean useEventQueue = false;
    protected Vector myListeners;

    public Timer() {
        this(1000L);
    }

    public Timer(long i) {
        this(i, true);
    }

    public Timer(long i, boolean isDaemon) {
        this.interval = i;
        this.daemon = isDaemon;
        this.myListeners = new Vector(1);
        this.enableEvents(0L);
        try {
            SecurityManager sec = System.getSecurityManager();
            if (sec != null) {
                sec.checkAwtEventQueueAccess();
            }
            this.useEventQueue = true;
        }
        catch (SecurityException securityException) {
            System.err.println("Unable to access event queue: timer events may be out of sync!");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long i) {
        this.interval = i;
    }

    public void stop() {
        this.myThread = null;
    }

    public void start() {
        this.enabled = true;
        this.myThread = new Thread((Runnable)this, "Timer Thread");
        this.myThread.setDaemon(this.daemon);
        this.myThread.start();
    }

    public void run() {
        while (this.myThread == Thread.currentThread()) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.enabled || this.myThread == null) continue;
            TimerEvent evt = new TimerEvent(this);
            if (this.useEventQueue) {
                EventQueue evtQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                evtQueue.postEvent(evt);
                continue;
            }
            this.processTimerEvent(evt);
        }
    }

    public synchronized void addTimerListener(TimerListener l) {
        this.myListeners.addElement(l);
    }

    public synchronized void removeTimerListener(TimerListener l) {
        this.myListeners.removeElement(l);
    }

    public void processEvent(AWTEvent evt) {
        if (evt instanceof TimerEvent) {
            this.processTimerEvent((TimerEvent)evt);
        } else {
            super.processEvent(evt);
        }
    }

    public void processTimerEvent(TimerEvent evt) {
        int i = 0;
        while (i < this.myListeners.size()) {
            ((TimerListener)this.myListeners.elementAt(i)).timerFired(evt);
            ++i;
        }
    }
}

