/*
 * Decompiled with CFR 0.152.
 */
package will;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import javax.swing.JPanel;
import will.shouldntGetHereException;

public class JBackgroundPanel
extends JPanel {
    Rectangle[] ComponentRect;
    Image sourceImage;
    Image scaledImage;
    Image bgImage;
    ImageFilter filter;

    public JBackgroundPanel() {
        this((Image)null);
    }

    public JBackgroundPanel(Image img) {
        this.sourceImage = img;
        this.bgImage = null;
        this.scaledImage = null;
        if (img != null) {
            this.setOpaque(true);
            this.filter = new backgroundPanelImageFilter();
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(img, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException e) {
                throw new shouldntGetHereException(e);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension result = super.getPreferredSize();
        if (this.sourceImage != null) {
            float compAspect;
            float imgAspect = (float)this.sourceImage.getHeight(null) / (float)this.sourceImage.getWidth(null);
            if (imgAspect < (compAspect = (float)result.height / (float)result.width)) {
                result.width = (int)((float)result.height / imgAspect);
            } else {
                result.height = (int)((float)result.width * imgAspect);
            }
        }
        return result;
    }

    public void validate() {
        super.validate();
        if (this.sourceImage != null) {
            if (this.bgImage != null) {
                this.bgImage.flush();
            }
            if (this.scaledImage != null) {
                this.scaledImage.flush();
            }
            this.ComponentRect = new Rectangle[this.getComponentCount()];
            Component[] comp = this.getComponents();
            int i = 0;
            while (i < this.ComponentRect.length) {
                this.ComponentRect[i] = comp[i].getBounds();
                ++i;
            }
            Dimension size = this.getSize();
            this.scaledImage = this.sourceImage.getScaledInstance(size.width, size.height, 1);
            ImageProducer src = this.scaledImage.getSource();
            this.bgImage = this.createImage(new FilteredImageSource(src, this.filter));
            this.prepareImage(this.bgImage, null);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.bgImage, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException e) {
                throw new shouldntGetHereException(e);
            }
        }
    }

    public void paintComponent(Graphics g) {
        if (!this.isValid()) {
            this.validate();
        }
        if (!this.isOpaque()) {
            return;
        }
        if (this.sourceImage != null) {
            if (this.bgImage == null) {
                this.validate();
                System.err.println("bgImage null: revalidating");
            }
            if (!this.prepareImage(this.bgImage, null)) {
                System.err.println("bgImage not prepared: waiting");
                MediaTracker myTracker = new MediaTracker(this);
                myTracker.addImage(this.bgImage, 0);
                try {
                    myTracker.waitForAll();
                }
                catch (InterruptedException e) {
                    throw new shouldntGetHereException(e);
                }
            }
            g.drawImage(this.bgImage, 0, 0, null);
        } else {
            super.paintComponent(g);
        }
    }

    class backgroundPanelImageFilter
    extends RGBImageFilter {
        private int processPixel(int rgb) {
            int alpha = rgb & 0xFF000000;
            rgb &= 0xFEFEFE;
            rgb >>= 1;
            return rgb |= alpha;
        }

        public int filterRGB(int x, int y, int rgb) {
            if (x == -1 && y == -1) {
                return rgb;
            }
            throw new shouldntGetHereException();
        }

        public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
            Rectangle thisRect = new Rectangle(x, y, w, h);
            int i = 0;
            while (i < JBackgroundPanel.this.ComponentRect.length) {
                if (JBackgroundPanel.this.ComponentRect[i].intersects(thisRect)) {
                    Rectangle r = JBackgroundPanel.this.ComponentRect[i].intersection(thisRect);
                    int index = off + scansize * (r.y - y) + (r.x - x);
                    int cy = 0;
                    while (cy < r.height) {
                        int cx = 0;
                        while (cx < r.width) {
                            pixels[index] = this.processPixel(pixels[index]);
                            ++index;
                            ++cx;
                        }
                        index += scansize - r.width;
                        ++cy;
                    }
                }
                ++i;
            }
            this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, off, scansize);
        }

        backgroundPanelImageFilter() {
        }
    }
}

