/*
 * Decompiled with CFR 0.152.
 */
package will;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;

public class ClosableJFrame
extends JFrame
implements WindowListener {
    public static boolean exitWhenWindowsGone = true;
    public static boolean disposeOnClose = true;
    protected static int WindowCount = 0;
    protected boolean inCount;

    public ClosableJFrame() {
        this.setup();
    }

    public ClosableJFrame(String name) {
        super(name);
        this.setup();
    }

    private void setup() {
        this.inCount = false;
        ((Component)this).setLocation(20, 20);
        this.addWindowListener(this);
    }

    protected void doCountChange(boolean vis) {
        if (vis) {
            if (!this.inCount) {
                ++WindowCount;
                this.inCount = true;
            }
        } else if (this.inCount) {
            this.inCount = false;
            --WindowCount;
        }
    }

    protected void checkForQuit() {
        if (WindowCount <= 0 && exitWhenWindowsGone) {
            System.exit(0);
        }
    }

    public void show() {
        this.doCountChange(true);
        super.show();
    }

    public void setVisible(boolean vis) {
        this.doCountChange(vis);
        super.setVisible(vis);
    }

    public void dispose() {
        this.doCountChange(false);
        super.dispose();
    }

    public void windowClosing(WindowEvent evt) {
        if (disposeOnClose) {
            this.dispose();
        } else {
            this.setVisible(false);
            this.checkForQuit();
        }
    }

    public void windowClosed(WindowEvent evt) {
        this.checkForQuit();
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }
}

