/** @file rt_material.h
 *
 *  @brief Describes a material
 *
 *  The parser constructs material objects to describe materials in the
 *  ray tracer scene. Add the necessary code and methods to interface this class
 *  with your ray tracer.
 *
 *  @author Initial design: Mark T. Tomczak (mtomczak)
 **/
 
#ifndef __RT_MATERIAL__
#define __RT_MATERIAL__

#include "rt_vectors.h"
#include "rt_parse.h"


class rt_Material {
public:
  /** @brief Constructor for group objects
   * 
   *  You should initialize your material object in this constructor
   *
   *  @param parser Pointer to the rt_parse class creating the material
   *  @param texture_name Name of texture file
   *  @param diffuse_color Diffuse reflective color of material
   *  @param specular_color Specular reflective color of material
   *  @param shininess Shininess coefficient of the material
   *  @param transparent_color Transmitted color of the material
   *  @param reflective_color Color that is reflected in the material
   *  @param refraction_index The material's index of refraction for 
   *         transmitted light
   **/
  rt_Material( rt_parse *parser, char *texture_name, Vec3f diffuse_color, 
               Vec3f specular_color, 
               float shininess, Vec3f transparent_color, 
               Vec3f reflective_color, float refraction_index);

};

#endif /* __RT_MATERIAL__ */

