/** @file rt_light.h
 *
 *  @brief Describes a positional light in the scene
 *
 *  Add the necessary code and methods to interface this class with 
 *  your ray tracer.
 *
 *  @author Initial design: Mark T. Tomczak (mtomczak) 
 *
 **/
 
#ifndef __RT_LIGHT__
#define __RT_LIGHT__

#include "rt_vectors.h"
#include "rt_parse.h"


class rt_Light{
public:
  /** @brief Constructor for the light class
   *
   *  @param parser Pointer to parser instantiating the light
   *  @param p Location of the light
   *  @param c Color of the light
   *  @param a1 First attenuation coefficient
   *  @param a2 Second attenuation coefficient
   *  @param a3 Third attenuation coefficient
   **/
  rt_Light(rt_parse *parser, Vec3f p, Vec3f c, float a1, float a2, float a3);
};

#endif /* __RT_LIGHT__ */
