/** @file rt_group.h
 *
 *  @brief Describes a group of objects
 *
 *  The rt_Group class is intended to collect objects in a uniform storage
 *  class. Add the necessary code and methods to interface this class with 
 *  your ray tracer.
 *
 *  @author Initial design: Mark T. Tomczak (mtomczak)
 ***/

#ifndef __RT_GROUP__
#define __RT_GROUP__

#include "rt_object.h"
#include "rt_parse.h"


class rt_Group {
public:
  /** @brief Constructor for group objects
   * 
   *  You should initialize your group object in this constructor
   *
   *  @param parser Pointer to the parser instantiating the object
   *
   **/
  rt_Group(rt_parse *parser);
  
  /** @brief Adds an object into the group
   *
   *  You should add the necessary code in this function 
   *  to retain knowledge of the object's membership 
   *  in the group
   *
   *  @param o Object to add
   **/
  virtual void add(rt_Object *o);
  

};

#endif /* __RT_GROUP__ */

