/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.TextArea;
import java.awt.Toolkit;

class TSysInfo {
    String userID;
    String userPWD;
    String strMailBox = null;
    long lgRefreshInterval = 900000L;
    boolean bDelAfterRetrieval = false;
    TextArea txaDebug;
    TextArea txaInfo;
    TextArea txaStatus;
    Choice choiceMail;
    boolean bUserReady = false;
    boolean bSafeMode;
    boolean bLimited;
    TSysInfoPanel myPanel;

    public TSysInfo() {
    }

    public TSysInfo(String string) {
        this();
        this.strMailBox = string;
    }

    public TSysInfo(String string, String string2, String string3) {
        this(string);
        try {
            this.SetUser(string2, string3);
            return;
        }
        catch (Exception exception) {
            this.ErrOut("Caught Exception: " + exception.getMessage());
            return;
        }
    }

    protected void RegPanel(TSysInfoPanel tSysInfoPanel) {
        this.myPanel = tSysInfoPanel;
    }

    public void SetTxaDebug(TextArea textArea) {
        this.txaDebug = textArea;
    }

    public void SetTxaInfo(TextArea textArea) {
        this.txaInfo = textArea;
    }

    public void SetStatusInfo(TextArea textArea) {
        this.txaStatus = textArea;
    }

    public void SetMailChoice(Choice choice) {
        this.choiceMail = choice;
    }

    public Choice getMailChoice() {
        return this.choiceMail;
    }

    public static String NewLine() {
        return System.getProperty("line.separator");
    }

    protected void SetUser(String string, String string2) throws Exception {
        if (string == null || string.equals("")) {
            this.UserClear();
            throw new Exception("Set User Error: UserId Can not be blank!");
        }
        this.userID = string;
        this.userPWD = string2;
        this.bUserReady = true;
    }

    protected void UserClear() {
        this.bUserReady = false;
    }

    protected void SetRefreshInv(long l) {
        this.lgRefreshInterval = l * 60000L;
    }

    protected void SetDelFlag(boolean bl) {
        this.bDelAfterRetrieval = bl;
    }

    protected long GetRefreshInv() {
        return this.lgRefreshInterval / 60000L;
    }

    public boolean UserReady() {
        return this.bUserReady;
    }

    public String GetUserID() {
        if (this.bUserReady) {
            return this.userID;
        }
        return "";
    }

    public String GetUserPWD() {
        if (this.bUserReady) {
            return this.userPWD;
        }
        return "";
    }

    public long GetRefreshInterval() {
        return this.lgRefreshInterval;
    }

    public String GetMboxName() {
        return this.strMailBox;
    }

    public boolean GetDelFlag() {
        return this.bDelAfterRetrieval;
    }

    public void Clear() {
        this.UserClear();
        this.InfoClear();
        this.DebugClear();
        this.myPanel.InitPara();
        this.choiceMail.removeAll();
    }

    public boolean refreshPara() {
        return this.myPanel.GetCurPara();
    }

    public void SetSafeFlag(boolean bl) {
        this.bSafeMode = bl;
    }

    public boolean GetSafeFlag() {
        return this.bSafeMode;
    }

    public void SetLimitedFlag(boolean bl) {
        this.bLimited = bl;
    }

    public boolean GetLimitedFlag() {
        return this.bLimited;
    }

    public void TestOut(String string) {
        System.out.println(string);
    }

    public static void Exclaim() {
        Toolkit.getDefaultToolkit().beep();
        Toolkit.getDefaultToolkit().beep();
    }

    public void ErrOut(String string) {
        TSysInfo.Exclaim();
        System.out.println(string);
    }

    public void DebugOut(String string) {
        if (this.txaDebug == null) {
            this.ErrOut("Warning: try to use txaDebug before it is assigned");
        }
        this.txaDebug.append(String.valueOf(string) + TSysInfo.NewLine());
    }

    public void InfoOut(String string) {
        if (this.txaInfo == null) {
            this.ErrOut("Warning: try to use txaInfo before it is assigned");
        }
        this.txaInfo.append(String.valueOf(string) + TSysInfo.NewLine());
    }

    public void StatusOut(String string) {
        if (this.txaStatus == null) {
            this.ErrOut("Warning: try to use txaStatus before it is assigned");
        }
        this.txaStatus.append(String.valueOf(string) + TSysInfo.NewLine());
    }

    public void DebugClear() {
        if (this.txaDebug == null) {
            this.ErrOut("Warning: try to use txaDebug before it is assigned");
        }
        this.txaDebug.setText("");
    }

    public void InfoClear() {
        if (this.txaInfo == null) {
            this.ErrOut("Warning: try to use txaInfo before it is assigned");
        }
        this.txaInfo.setText("");
    }

    public void StatusClear() {
        if (this.txaStatus == null) {
            this.ErrOut("Warning: try to use txaStatus before it is assigned");
        }
        this.txaStatus.setText("");
    }
}

