function gradview(frame, k, win)

[fx, fy, gauss] = filters(k);

Ix = conv2(frame, fx, 'same');
Iy = conv2(frame, fy, 'same');

Ixx = Ix .* Ix;
Ixy = Ix .* Iy;
Iyy = Iy .* Iy;

Sxx = conv2(Ixx, gauss, 'same');
Syy = conv2(Iyy, gauss, 'same');
Sxy = conv2(Ixy, gauss, 'same');

dscale = max(abs([Ix(:); Iy(:)]));
figure(1);
colormap gray;
imagesc(frame);
capno = 1;
done = 0;
while ~done
  figure(1);
  [mx, my, but] = ginput(1);
  mx = round(mx);
  my = round(my);
  if (but == 'q')
    done = 1;
    continue;
  elseif (but == 'p')
    figure(2);
    print('-depsc', sprintf('grad%03d.eps', capno));
    print('-dpng', '-r72', sprintf('grad%03d.png', capno));
    figure(1);
    print('-depsc', sprintf('box%03d.eps', capno));
    print('-dpng', '-r72',  sprintf('box%03d.png', capno));
    capno = capno + 1;
    continue;
  end
  imagesc(frame);
  hold on;
  h = line([mx-win, mx+win-1, mx+win-1, mx-win, mx-win], [my-win, my-win, my+win-1, my+win-1, my-win]);
  set(h, 'Color', [1 1 0], 'LineWidth', 1);
  h = line([mx-win-2, mx+win+1, mx+win+1, mx-win-2, mx-win-2], [my-win-2, my-win-2, my+win+1, my+win+1, my-win-2]);
  set(h, 'Color', [0 0 0], 'LineWidth', 1);
  hold off;
  ixs = Ix(my-win:my+win, mx-win:mx+win);
  iys = Iy(my-win:my+win, mx-win:mx+win);
  ixs = ixs(:);
  iys = iys(:);
  figure(2);
  subplot(1,3,[1 2]);
  plot(-ixs, iys, 'bx');
  axis image;
  axis([-dscale dscale -dscale dscale]);
  subplot(1,3,3)
  thetas = pi + atan2(ixs, iys);
  rs = sqrt(ixs.^2 + iys.^2);
  his = sum(sparse(1:length(thetas), floor(thetas * 10)+1, rs, length(thetas),63));
  plot(his, 0:.1:2*pi);
end
