function barview(frame, k)

res = 99;

[fx, fy, gauss] = filters(k);

S = conv2(frame, gauss, 'same');
Ix = conv2(frame, fx, 'same');
Iy = conv2(frame, fy, 'same');

figure(1);
colormap gray;
imagesc(frame);
capno = 1;
done = 0;
while ~done
  figure(1);
  [mx, my, but] = ginput(2);
  mx = round(mx);
  my = round(my);
  if (but == 'q')
    done = 1;
    continue;
  elseif (but == 'p')
    figure(2);
    print('-dpng', '-r72', sprintf('baredges%03d.png', capno));
    figure(1);
    print('-dpng', '-r72',  sprintf('barloc%03d.png', capno));
    capno = capno + 1;
    continue;
  end
  dx = (mx(2) - mx(1)) / res;
  dy = (my(2) - my(1)) / res;
  len = sqrt(dx*dx + dy*dy);
  imagesc(frame);
  hold on;
  h = line(mx+5*dy/len, my-5*dx/len);
  set(h, 'Color', [0 0 0], 'LineWidth', 2);
  h = line(mx-5*dy/len, my+5*dx/len);
  set(h, 'Color', [0 0 0], 'LineWidth', 2);
  h = line(mx, my);
  set(h, 'Color', [1 1 0], 'LineWidth', 2);
  hold off;
  idx = sub2ind(size(S), round(my(1)+.5*dy:dy:my(2)), round(mx(1)+.5*dx:dx:mx(2)));
  bars = S(idx);
  edges = dx * Ix(idx) + dy * Ix(idx);
  edges = edges .* edges;

  maxes = ([0 edges 0] > [0 0 edges]) .* ([0 edges 0] > [edges 0 0]);
  midx = find(maxes);
  if (length(midx) < 10)
    fprintf('counted fewer than 10 edges\n');
    continue;
  end
  sedges = sort(edges(midx-1))
  cutoff = sedges(end+1-10);
  maxes = maxes .* ([0 edges 0] >= cutoff);
  midx = find(maxes);
  midx = midx - min(midx);
  len = max(midx) / 12;
  diff = (midx(2:end) - midx(1:end-1)) / len;
  barcode = diff > 1.5;
  if (barcode(1) ~= 0) || (barcode(end) ~= 0)
    fprintf('missed beginning or ending narrow bar\n');
    continue;
  end

  figure(2);
  subplot(2,1,1);
  plot(bars, 'LineWidth', 2);
  subplot(2,1,2);
  plot(edges, 'LineWidth', 2);
  hold on;
  plot(1:res, cutoff*ones(1,res));
  hold off;
  barcode
end
