% VIEWRESULTS(MOVIE, XS, YS, WTS)
%
% Display dot tracking results and allow user to edit them.

%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function viewresults(movie, xs, ys, wts)

% pick a subframe of the movie

margin = 15;

[n, m, zmax] = size(movie{1});

xmin = round(min(xs(:)) - margin);
xmax = round(max(xs(:)) + margin);
xmin = max(1, xmin);
xmax = min(m, xmax);

ymin = round(min(ys(:)) - margin);
ymax = round(max(ys(:)) + margin);
ymin = max(1, ymin);
ymax = min(n, ymax);

% loop to examine all frames

  fprintf('Commands\n');
  fprintf('  <return> or f<return>: forward a frame\n');
  fprintf('  b<return>: backward a frame\n');
  fprintf('  [<return>: go to beginning\n');
  fprintf('  ]<return>: go to end\n');
  fprintf('  h<return>: toggle hiding of markers\n');
  fprintf('  x<return>: exit\n');

frame = 1;
hiding = 0;
while (frame > 0 & frame <= length(movie))
  imagesc(sum(movie{frame}(ymin:ymax,xmin:xmax,:),3));
  if (~hiding)
    hold on
    plot(xs(1,frame) - xmin + 1, ys(1,frame) - ymin + 1,'rx');
    plot(xs(2,frame) - xmin + 1, ys(2,frame) - ymin + 1,'go');
    hold off
  end
  fprintf('\nX1: %g, Y1: %g, X2: %g, Y2: %g, wt: %g\n', xs(1, frame), ...
	  ys(1, frame), xs(2, frame), ys(2, frame), wts(frame));
  cmd = input('Command: ', 's');
  if (isequal(cmd, ''))
    frame = frame + 1;
    hiding = 0;
  elseif (isequal(cmd, 'f'))
    frame = frame + 1;
    hiding = 0;
  elseif (isequal(cmd, 'b'))
    frame = frame - 1;
    hiding = 0;
  elseif (isequal(cmd, '['))
    frame = 1;
    hiding = 0;
  elseif (isequal(cmd, ']'))
    frame = length(movie);
    hiding = 0;
  elseif (isequal(cmd, 'h'))
    hiding = ~hiding;
  elseif (isequal(cmd, 'x'))
    frame = 0;
  end
end
