%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function [xs,ys,wts] = track2(movie)

% ask user for initial positions
imagesc(sum(movie{1},3));
axis image
[x, y] = ginput(2);

% for each frame in the movie
xs = [];
ys = [];
wts = [];
for fr = 1:length(movie)

  % collapse z levels
  frame = sum(movie{fr},3);
%  imagesc(frame);
%  axis image;

  % get candidate matches for each dot
  cx = zeros(3,2);
  cy = zeros(3,2);
  wt = zeros(3,2);
  for i = 1:2
    [cx(:,i),cy(:,i),wt(:,i)] = candmatch(frame,x(i),y(i),3);
  end
  
  % plot candidate matches
%  hold on
%  plot(cx(1,1),cy(1,1),'ro','MarkerSize',10);
%  plot(cx(2,1),cy(2,1),'r^','MarkerSize',10);
%  plot(cx(3,1),cy(3,1),'rs','MarkerSize',10);
%  plot(cx(1,2),cy(1,2),'go','MarkerSize',12);
%  plot(cx(2,2),cy(2,2),'g^','MarkerSize',12);
%  plot(cx(3,2),cy(3,2),'gs','MarkerSize',12);
%  hold off
  
  % search for best pair of matches
  bestwt = -1;
  besti = 0;
  bestj = 0;
  for i = 1:3
    for j = 1:3
      thiswt = wt(i,1) * wt(j,2);
      if ((abs(cx(i,1) - cx(j,2)) <= 1) & (abs(cy(i,1) - cy(j,2)) <= 1))
	thiswt = 0;
      end
      if (thiswt > bestwt)
	bestwt = thiswt;
	besti = i;
	bestj = j;
      end
    end
  end
  
  x(1) = cx(besti,1);
  y(1) = cy(besti,1);
  x(2) = cx(bestj,2);
  y(2) = cy(bestj,2);
  xs = [xs x];
  ys = [ys y];
  wts = [wts bestwt];

%  hold on
%  plot(x(1),y(1),'rd','MarkerSize',15);
%  plot(x(2),y(2),'gd','MarkerSize',15);
%  hold off;
%print('-djpeg',sprintf('track2-%02d',fr));
%  pause

end

