% Plot 2D projections of a 3D image

%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function im3(image)

scale = .8;
marg = .1;
hmarg = .5 * marg;

clf

axes('position', [.8+hmarg .2+hmarg 1-scale-marg scale-marg]);
imagesc(squeeze(sum(image,2)));

axes('position', [hmarg hmarg scale-marg 1-scale-marg]);
imagesc(squeeze(sum(image,1))');

axes('position', [hmarg (1-scale+hmarg) scale-marg scale-marg]);
imagesc(sum(image,3));



