% RUN
%
% Main entry point for DotTrack TwoD.
%
% Please edit this file to include the correct pathname for your movie
% and the desired prefix for output files.


%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

fprintf('DotTrack v 0.1, Copyright (C) 2005 Geoff Gordon, Andrew Gove\n\n');
fprintf('DotTrack comes with ABSOLUTELY NO WARRANTY; for details see\n');
fprintf('the file LICENSE.TXT in the distribution.  This is free software,\n');
fprintf('and you are welcome to redistribute it under certain conditions;\n');
fprintf('again, see LICENSE.TXT for details.\n\n');
fprintf('Please edit the file run.m to include the correct pathname for\n');
fprintf('your movie and the desired prefix for output files.\n\n');

movie = loadmovie('26_w528_t%02d_z%02d.tif',1:15,1:1);
prefix = 'mkhrt26';

track = 1;
while (1)

  fprintf('Select pair of points for track %d\n', track);
  colormap gray;
  [xs, ys, wts] = track2(movie);

  % polish each candidate
  for i = 1:length(movie)
    [xs(1,i), ys(1,i)] = polish(sum(movie{i},3), xs(1,i), ys(1,i));
    [xs(2,i), ys(2,i)] = polish(sum(movie{i},3), xs(2,i), ys(2,i));
  end

  viewresults(movie, xs, ys, wts);
  
  while (1)
    cmd = input('[s]ave, [d]iscard, e[x]it, or e[X]it without saving: ', 's');

    if (isequal(cmd, 's') | isequal(cmd, 'x'))
      csvwrite(sprintf('%s-%03d-xs.csv',prefix,track), xs);
      csvwrite(sprintf('%s-%03d-ys.csv',prefix,track), ys);
      csvwrite(sprintf('%s-%03d-wts.csv',prefix,track), wts);
      track = track + 1;
    end

    if (isequal(cmd, 's'))
      break;
    elseif (isequal(cmd, 'd'))
      break;
    elseif (isequal(cmd, 'x'))
      return;
    elseif (isequal(cmd, 'X'))
      return;
    end
  end

end

