% [PX, PY] = POLISH(IM, X, Y)
%
% Polish a candidate dot match to get subpixel accuracy.

%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function [px, py] = polish(im, x, y)

% minimum x/y increment
delta = .05;

% pick a sub-image to work with
[n,m] = size(im);
xmin = max(floor(x)-4, 1);
xmax = min(ceil(x)+4, m);
ymin = max(floor(y)-4, 1);
ymax = min(ceil(y)+4, n);
im = im(ymin:ymax,xmin:xmax);
m = xmax - xmin + 1;
n = ymax - ymin + 1;
x = x - xmin + 1;
y = y - ymin + 1;
[xs,ys] = meshgrid(1:m, 1:n);

% blur image to reduce noise
filt = [.25 .5 .25];
im = conv2(filt, filt, im, 'same');

% test points
[tx,ty] = meshgrid(x-1:delta:x+1, y-1:delta:y+1);

% bicubic spline interpolant
fval = interp2(xs,ys,im,tx,ty,'cubic');

% location of maximum
[maxval,ind] = max(fval(:));
px = tx(ind) + xmin - 1;
py = ty(ind) + ymin - 1;
