% VIEWRESULTS(MOVIE, XS, YS, ZS, WTS, NPOINTS)
%
% Display dot tracking results and allow user to edit them.


%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function viewresults(movie, xs, ys, zs, wts, npoints)

% pick a subframe of the movie

margin = 15;

[n, m, zmax] = size(movie{1});

xmin = round(min(xs(:)) - margin);
xmax = round(max(xs(:)) + margin);
xmin = max(1, xmin);
xmax = min(m, xmax);

ymin = round(min(ys(:)) - margin);
ymax = round(max(ys(:)) + margin);
ymin = max(1, ymin);
ymax = min(n, ymax);

% loop to examine all frames

  fprintf('Commands\n');
  fprintf('  <return> or f<return>: forward a frame\n');
  fprintf('  b<return>: backward a frame\n');
  fprintf('  [<return>: go to beginning\n');
  fprintf('  ]<return>: go to end\n');
  fprintf('  h<return>: toggle hiding of markers\n');
  fprintf('  x<return>: exit\n');

frame = 1;
hiding = 0;
markers = {'r+','gs','bo','cd'};
while (frame > 0 & frame <= length(movie))
%  frim1 = sum(movie{frame}(ymin:ymax,xmin:xmax,1:3:end),3);
%  frim2 = sum(movie{frame}(ymin:ymax,xmin:xmax,2:3:end),3);
%  frim3 = sum(movie{frame}(ymin:ymax,xmin:xmax,3:3:end),3);
%  maxfrim = max([frim1(:); frim2(:); frim3(:)]);
%  image(cat(3, frim1, frim2, frim3)/maxfrim);

  subplot('position', [.05 .2 .75 .75]);
  imagesc(max(movie{frame}(ymin:ymax,xmin:xmax,:),[],3));
  axis off;
  subplot('position', [.05 .05 .75 .1]);
  imagesc(max(permute(movie{frame}(ymin:ymax,xmin:xmax,:),[3 2 1]),[],3));
  subplot('position', [.86 .2 .08 .75]);
  imagesc(max(permute(movie{frame}(ymin:ymax,xmin:xmax,:),[1 3 2]),[],3));
  
  if (~hiding)
    subplot('position', [.05 .2 .75 .75]);
    hold on
    for i = 1:npoints
      plot(xs(i,frame) - xmin + 1, ys(i,frame) - ymin + 1, markers{i});
    end
    hold off

    subplot('position', [.05 .05 .75 .1]);
    hold on
    for i = 1:npoints
      plot(xs(i,frame) - xmin + 1, zs(i,frame), markers{i});
    end
    hold off

    subplot('position', [.86 .2 .08 .75]);
    hold on
    for i = 1:npoints
      plot(zs(i,frame), ys(i,frame) - ymin + 1, markers{i});
    end
    hold off
  end
  str = sprintf('\n');
  for i = 1:npoints
    newstr = sprintf('X%d: %g, Y%d: %g, Z%d: %g, ', i, xs(i, frame), i, ys(i, frame), i, zs(i, frame));
    str = [str newstr];
  end
  newstr = sprintf('wt: %g\n', wts(frame));
  fprintf('%s%s', str, newstr);
  
  cmd = input('Command: ', 's');
  if (isequal(cmd, ''))
    frame = frame + 1;
    hiding = 0;
  elseif (isequal(cmd, 'f'))
    frame = frame + 1;
    hiding = 0;
  elseif (isequal(cmd, 'b'))
    frame = frame - 1;
    hiding = 0;
  elseif (isequal(cmd, '['))
    frame = 1;
    hiding = 0;
  elseif (isequal(cmd, ']'))
    frame = length(movie);
    hiding = 0;
  elseif (isequal(cmd, 'h'))
    hiding = ~hiding;
  elseif (isequal(cmd, 'x'))
    frame = 0;
  end
end
