
%    Copyright (C) 2005
%    Geoff Gordon  ggordon@cs.cmu.edu
%    Andrew Gove
%
%    This file is part of DotTrack, dot tracking software for
%    fluorescence microscope images.
%
%    DotTrack is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published
%    by the Free Software Foundation; either version 2 of the License,
%    or (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
%    02110-1301 USA

function [xs,ys,wts] = track2(movie, npoints)

% ask user for initial positions
%frim1 = sum(movie{1}(:,:,1:3:end),3);
%frim2 = sum(movie{1}(:,:,2:3:end),3);
%frim3 = sum(movie{1}(:,:,3:3:end),3);
%maxfrim = max([frim1(:); frim2(:); frim3(:)]);
%image(cat(3, frim1, frim2, frim3)/maxfrim);

% Display the image projected through the Z-axis
imagesc(sum(movie{1},3));
axis image

% Get a bunch of points (x and y are arrays, not scalars)
[x, y] = ginput(npoints);

% Initialize return values to empty lists
xs = [];
ys = [];
wts = [];

% Number of candidate dot locations to keep track of
ncandidates = 3;

% for each frame in the movie
for fr = 1:length(movie)

% collapse z levels
%  frame = max(movie{fr},[],3);
  frame = sum(movie{fr},3);

%  imagesc(frame);
%  axis image;

  % get candidate matches for each dot
  % "cx" = candidate x(max number of candidates, dot #n)
  cx = zeros(ncandidates,npoints);
  cy = zeros(ncandidates,npoints);
  % "wt" = weight a.k.a. reliability metric
  wt = zeros(ncandidates,npoints);
  for i = 1:npoints
    [cx(:,i),cy(:,i),wt(:,i)] = candmatch(frame,x(i),y(i),ncandidates);
  end
  
  % plot candidate matches
%  hold on
%  plot(cx(1,1),cy(1,1),'ro','MarkerSize',10);
%  plot(cx(2,1),cy(2,1),'r^','MarkerSize',10);
%  plot(cx(3,1),cy(3,1),'rs','MarkerSize',10);
%  plot(cx(1,2),cy(1,2),'go','MarkerSize',12);
%  plot(cx(2,2),cy(2,2),'g^','MarkerSize',12);
%  plot(cx(3,2),cy(3,2),'gs','MarkerSize',12);
%  hold off
  
  % search for best set of matches via cross-comparison
  % i iterates through all candidates for dot #1
  % j iterates through all candidates for dot #2
  bestwt = -1;
  besti = 0;
  bestj = 0;
  bestk = 0;
  bestm = 0;
  
  if (npoints == 1)
      for i = 1:ncandidates
          thiswt = wt(i,1);
          if (thiswt > bestwt)
        bestwt = thiswt;
        besti = i;
          end
      end
  end

  % There has got to be a better, more efficient way to write these loops
  if (npoints == 2)
      for i = 1:ncandidates
        for j = 1:ncandidates
          thiswt = wt(i,1) * wt(j,2);
          % discourage adjacent selections
          if ((abs(cx(i,1) - cx(j,2)) <= 1) && (abs(cy(i,1) - cy(j,2)) <= 1))
        thiswt = 0;
          end
          if (thiswt > bestwt)
        bestwt = thiswt;
        besti = i;
        bestj = j;
          end
        end
      end
  end

  if (npoints == 3)
      for i = 1:ncandidates
        for j = 1:ncandidates
          for k = 1:ncandidates
            thiswt = wt(i,1) * wt(j,2) * wt(k,3);
            % discourage adjacent selections
            if ((abs(cx(i,1) - cx(j,2)) <= 1) && (abs(cy(i,1) - cy(j,2)) <= 1) || (abs(cx(i,1) - cx(k,3)) <= 1) && (abs(cy(i,1) - cy(k,3)) <= 1) || (abs(cx(k,3) - cx(j,2)) <= 1) && (abs(cy(k,3) - cy(j,2)) <= 1))
          thiswt = 0;
            end
            if (thiswt > bestwt)
          bestwt = thiswt;
          besti = i;
          bestj = j;
          bestk = k;
            end
          end
        end
      end
  end

  if (npoints == 4)
      for i = 1:ncandidates
        for j = 1:ncandidates
          for k = 1:ncandidates
            for m = 1:ncandidates
            thiswt = wt(i,1) * wt(j,2) * wt(k,3) * wt(m,4);
            % discourage adjacent selections
            if ((abs(cx(i,1) - cx(j,2)) <= 1) && (abs(cy(i,1) - cy(j,2)) <= 1) || (abs(cx(i,1) - cx(k,3)) <= 1) && (abs(cy(i,1) - cy(k,3)) <= 1) || (abs(cx(k,3) - cx(j,2)) <= 1) && (abs(cy(k,3) - cy(j,2)) <= 1))
          thiswt = 0;
            end
            if ((abs(cx(m,4) - cx(j,2)) <= 1) && (abs(cy(m,4) - cy(j,2)) <= 1) || (abs(cx(m,4) - cx(k,3)) <= 1) && (abs(cy(m,4) - cy(k,3)) <= 1) || (abs(cx(k,3) - cx(j,2)) <= 1) && (abs(cy(k,3) - cy(j,2)) <= 1))
          thiswt = 0;
            end
            if ((abs(cx(i,1) - cx(m,4)) <= 1) && (abs(cy(i,1) - cy(m,4)) <= 1) || (abs(cx(i,1) - cx(k,3)) <= 1) && (abs(cy(i,1) - cy(k,3)) <= 1) || (abs(cx(k,3) - cx(m,4)) <= 1) && (abs(cy(k,3) - cy(m,4)) <= 1))
          thiswt = 0;
            end
            if ((abs(cx(i,1) - cx(j,2)) <= 1) && (abs(cy(i,1) - cy(j,2)) <= 1) || (abs(cx(i,1) - cx(m,4)) <= 1) && (abs(cy(i,1) - cy(m,4)) <= 1) || (abs(cx(m,4) - cx(j,2)) <= 1) && (abs(cy(m,4) - cy(j,2)) <= 1))
          thiswt = 0;
            end
            if (thiswt > bestwt)
          bestwt = thiswt;
          besti = i;
          bestj = j;
          bestk = k;
          bestm = m;
            end
            end
          end
        end
      end
  end

  % update "current" dot positions with selected candidates  
  x(1) = cx(besti,1);
  y(1) = cy(besti,1);
  if (npoints > 1)
    x(2) = cx(bestj,2);
    y(2) = cy(bestj,2);
  end
  if (npoints > 2)
    x(3) = cx(bestk,3);
    y(3) = cy(bestk,3);
  end
  if (npoints > 3)
    x(4) = cx(bestm,4);
    y(4) = cy(bestm,4);
  end
  
  % record selections for function return values
  xs = [xs x];
  ys = [ys y];
  wts = [wts bestwt];

%  hold on
%  plot(x(1),y(1),'rd','MarkerSize',15);
%  plot(x(2),y(2),'gd','MarkerSize',15);
%  hold off;
%print('-djpeg',sprintf('track2-%02d',fr));
%  pause

end

